// ChangeEmailWelcome
function ChangeEmailWelcome(id) {
  Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert this status!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, change status!',
    customClass: {
      confirmButton: 'btn btn-primary me-2',
      cancelButton: 'btn btn-label-secondary'
    },
    buttonsStyling: false
  }).then(function (result) {
    if (result.isConfirmed) {
      var isChecked = $('#email-welcome-checkbox').is(':checked') ? 1 : 0; // Select using the specific id

      $.ajax({
        url: '/changeemail-emailwelcome/' + id,
        type: 'get',
        data: { get_email: isChecked },
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (data) {
          if (data.success) {
            Swal.fire({
              icon: 'success',
              title: 'Changed!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-success'
              }
            }).then(function () {
              location.reload();
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-danger'
              }
            });
          }
        },
        error: function (xhr, status, error) {
          Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'There was an error changing the status.',
            customClass: {
              confirmButton: 'btn btn-danger'
            }
          });
        }
      });
    } else {
      Swal.fire({
        title: 'Cancelled',
        text: 'Action cancelled :)',
        icon: 'error',
        customClass: {
          confirmButton: 'btn btn-success'
        }
      }).then(function () {
        location.reload();
      });
    }
  });
}


// ChangeEmailOtpVerify
function ChangeEmailOtpVerify(id) {
  Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert this status!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, change status!',
    customClass: {
      confirmButton: 'btn btn-primary me-2',
      cancelButton: 'btn btn-label-secondary'
    },
    buttonsStyling: false
  }).then(function (result) {
    if (result.isConfirmed) {
      var isChecked = $('#email-otpverify-checkbox').is(':checked') ? 1 : 0; // Select using the specific id

      $.ajax({
        url: '/changeemail-emailotpverify/' + id,
        type: 'get',
        data: { get_email: isChecked },
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (data) {
          if (data.success) {
            Swal.fire({
              icon: 'success',
              title: 'Changed!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-success'
              }
            }).then(function () {
              location.reload();
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-danger'
              }
            });
          }
        },
        error: function (xhr, status, error) {
          Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'There was an error changing the status.',
            customClass: {
              confirmButton: 'btn btn-danger'
            }
          });
        }
      });
    } else {
      Swal.fire({
        title: 'Cancelled',
        text: 'Action cancelled :)',
        icon: 'error',
        customClass: {
          confirmButton: 'btn btn-success'
        }
      }).then(function () {
        location.reload();
      });
    }
  });
}


// ChangeEmailStoreApproved
function ChangeEmailStoreApproved(id) {
  Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert this status!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, change status!',
    customClass: {
      confirmButton: 'btn btn-primary me-2',
      cancelButton: 'btn btn-label-secondary'
    },
    buttonsStyling: false
  }).then(function (result) {
    if (result.isConfirmed) {
      var isChecked = $('#email-storeapproved-checkbox').is(':checked') ? 1 : 0; // Select using the specific id

      $.ajax({
        url: '/changeemail-emailstoreapproved/' + id,
        type: 'get',
        data: { get_email: isChecked },
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (data) {
          if (data.success) {
            Swal.fire({
              icon: 'success',
              title: 'Changed!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-success'
              }
            }).then(function () {
              location.reload();
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-danger'
              }
            });
          }
        },
        error: function (xhr, status, error) {
          Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'There was an error changing the status.',
            customClass: {
              confirmButton: 'btn btn-danger'
            }
          });
        }
      });
    } else {
      Swal.fire({
        title: 'Cancelled',
        text: 'Action cancelled :)',
        icon: 'error',
        customClass: {
          confirmButton: 'btn btn-success'
        }
      }).then(function () {
        location.reload();
      });
    }
  });
}


// ChangeEmailStoreRejected
function ChangeEmailStoreRejected(id) {
  Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert this status!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, change status!',
    customClass: {
      confirmButton: 'btn btn-primary me-2',
      cancelButton: 'btn btn-label-secondary'
    },
    buttonsStyling: false
  }).then(function (result) {
    if (result.isConfirmed) {
      var isChecked = $('#email-storerejected-checkbox').is(':checked') ? 1 : 0; // Select using the specific id

      $.ajax({
        url: '/changeemail-emailstorerejected/' + id,
        type: 'get',
        data: { get_email: isChecked },
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (data) {
          if (data.success) {
            Swal.fire({
              icon: 'success',
              title: 'Changed!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-success'
              }
            }).then(function () {
              location.reload();
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-danger'
              }
            });
          }
        },
        error: function (xhr, status, error) {
          Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'There was an error changing the status.',
            customClass: {
              confirmButton: 'btn btn-danger'
            }
          });
        }
      });
    } else {
      Swal.fire({
        title: 'Cancelled',
        text: 'Action cancelled :)',
        icon: 'error',
        customClass: {
          confirmButton: 'btn btn-success'
        }
      }).then(function () {
        location.reload();
      });
    }
  });
}


// ChangeEmailStoreWaiting
function ChangeEmailStoreWaiting(id) {
  Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert this status!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, change status!',
    customClass: {
      confirmButton: 'btn btn-primary me-2',
      cancelButton: 'btn btn-label-secondary'
    },
    buttonsStyling: false
  }).then(function (result) {
    if (result.isConfirmed) {
      var isChecked = $('#email-storewaiting-checkbox').is(':checked') ? 1 : 0; // Select using the specific id

      $.ajax({
        url: '/changeemail-emailstorewaiting/' + id,
        type: 'get',
        data: { get_email: isChecked },
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (data) {
          if (data.success) {
            Swal.fire({
              icon: 'success',
              title: 'Changed!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-success'
              }
            }).then(function () {
              location.reload();
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-danger'
              }
            });
          }
        },
        error: function (xhr, status, error) {
          Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'There was an error changing the status.',
            customClass: {
              confirmButton: 'btn btn-danger'
            }
          });
        }
      });
    } else {
      Swal.fire({
        title: 'Cancelled',
        text: 'Action cancelled :)',
        icon: 'error',
        customClass: {
          confirmButton: 'btn btn-success'
        }
      }).then(function () {
        location.reload();
      });
    }
  });
}


// ChangeEmailVendorSwitch
function ChangeEmailVendorSwitch(id) {
  Swal.fire({
    title: 'Are you sure?',
    text: "You won't be able to revert this status!",
    icon: 'warning',
    showCancelButton: true,
    confirmButtonText: 'Yes, change status!',
    customClass: {
      confirmButton: 'btn btn-primary me-2',
      cancelButton: 'btn btn-label-secondary'
    },
    buttonsStyling: false
  }).then(function (result) {
    if (result.isConfirmed) {
      var isChecked = $('#email-vendorswitch-checkbox').is(':checked') ? 1 : 0; // Select using the specific id

      $.ajax({
        url: '/changeemail-emailvendorswitch/' + id,
        type: 'get',
        data: { get_email: isChecked },
        headers: {
          'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        },
        success: function (data) {
          if (data.success) {
            Swal.fire({
              icon: 'success',
              title: 'Changed!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-success'
              }
            }).then(function () {
              location.reload();
            });
          } else {
            Swal.fire({
              icon: 'error',
              title: 'Error!',
              text: data.message,
              customClass: {
                confirmButton: 'btn btn-danger'
              }
            });
          }
        },
        error: function (xhr, status, error) {
          Swal.fire({
            icon: 'error',
            title: 'Error!',
            text: 'There was an error changing the status.',
            customClass: {
              confirmButton: 'btn btn-danger'
            }
          });
        }
      });
    } else {
      Swal.fire({
        title: 'Cancelled',
        text: 'Action cancelled :)',
        icon: 'error',
        customClass: {
          confirmButton: 'btn btn-success'
        }
      }).then(function () {
        location.reload();
      });
    }
  });
}
