function updateWelcomeEmail(templateData) {
  // Update the title and body
  document.getElementById('emailwelcome-logo').src =
    templateData.logo || '/assets/images/socialmedialogo/default-logo.png';

  document.getElementById('emailwelcome-title').textContent = templateData.title || '';
  document.getElementById('emailwelcome-body').textContent =
    templateData.body ||
    '';

  document.getElementById('emailwelcome-sectionuscontact').textContent =
    templateData.section_text || '';

  // Update policy links
  document.getElementById('emailwelcome-privacypolicy').style.display = templateData.privacy_policy
    ? 'inline'
    : 'none';

  document.getElementById('emailwelcome-refundpolicy').style.display = templateData.refund_policy ? 'inline' : 'none';
  document.getElementById('emailwelcome-cancellationpolicy').style.display = templateData.cancellation_policy
    ? 'inline'
    : 'none';
  document.getElementById('emailwelcome-contactus').style.display = templateData.contact_us ? 'inline' : 'none';

  // Update social media links
  document.getElementById('emailwelcome-twitterlink').style.display = templateData.twitter ? 'inline' : 'none';
  document.getElementById('emailwelcome-linkdlnlink').style.display = templateData.linkedIn ? 'inline' : 'none';
  document.getElementById('emailwelcome-instagramlink').style.display = templateData.instagram ? 'inline' : 'none';
  document.getElementById('emailwelcome-facebooklink').style.display = templateData.facebook ? 'inline' : 'none';

  // Update copyright content
  document.getElementById('emailwelcome-copyrightcontent').textContent =
    templateData.copyright_content || '';
}


function updateEmailOtpVerify(templateData) {
  // Update the title and body
  document.getElementById('emailotpverify-logo').src =
    templateData.logo || '/assets/images/socialmedialogo/default-logo.png';

  document.getElementById('emailotpverify-title').textContent = templateData.title || '';
  // document.getElementById('emailotpverify-title2').textContent = templateData.title || '';
  document.getElementById('emailotpverify-body').textContent =
    templateData.body ||
    '';

  document.getElementById('emailotpverify-sectionuscontact').textContent =
    templateData.section_text || '';

  // Update policy links
  document.getElementById('emailotpverify-privacypolicy').style.display = templateData.privacy_policy
    ? 'inline'
    : 'none';

  document.getElementById('emailotpverify-refundpolicy').style.display = templateData.refund_policy ? 'inline' : 'none';
  document.getElementById('emailotpverify-cancellationpolicy').style.display = templateData.cancellation_policy
    ? 'inline'
    : 'none';
  document.getElementById('emailotpverify-contactus').style.display = templateData.contact_us ? 'inline' : 'none';

  // Update social media links
  document.getElementById('emailotpverify-twitterlink').style.display = templateData.twitter ? 'inline' : 'none';
  document.getElementById('emailotpverify-linkdlnlink').style.display = templateData.linkedIn ? 'inline' : 'none';
  document.getElementById('emailotpverify-instagramlink').style.display = templateData.instagram ? 'inline' : 'none';
  document.getElementById('emailotpverify-facebooklink').style.display = templateData.facebook ? 'inline' : 'none';

  // Update copyright content
  document.getElementById('emailotpverify-copyrightcontent').textContent =
    templateData.copyright_content || '';
}


function updateEmailStoreApproved(templateData) {
  // Update the title and body
  document.getElementById("emailstoreapproved-logo").src =
    templateData.logo || "/assets/images/socialmedialogo/default-logo.png";

  document.getElementById("emailstoreapproved-title").textContent =
    templateData.title || "";

  document.getElementById("emailstoreapproved-body").textContent =
    templateData.body || "";

  document.getElementById("emailstoreapproved-sectionuscontact").textContent =
    templateData.section_text || "";

  // Update policy links
  document.getElementById("emailstoreapproved-privacypolicy").style.display =
    templateData.privacy_policy ? "inline" : "none";

  document.getElementById("emailstoreapproved-refundpolicy").style.display =
    templateData.refund_policy ? "inline" : "none";
  document.getElementById(
    "emailstoreapproved-cancellationpolicy"
  ).style.display = templateData.cancellation_policy ? "inline" : "none";
  document.getElementById("emailstoreapproved-contactus").style.display =
    templateData.contact_us ? "inline" : "none";

  // Update social media links
  document.getElementById("emailstoreapproved-twitterlink").style.display =
    templateData.twitter ? "inline" : "none";
  document.getElementById("emailstoreapproved-linkdlnlink").style.display =
    templateData.linkedIn ? "inline" : "none";
  document.getElementById("emailstoreapproved-instagramlink").style.display =
    templateData.instagram ? "inline" : "none";
  document.getElementById("emailstoreapproved-facebooklink").style.display =
    templateData.facebook ? "inline" : "none";

  // Update copyright content
  document.getElementById("emailstoreapproved-copyrightcontent").textContent =
    templateData.copyright_content || "";
}


function updateEmailStoreRejected(templateData) {
  // Update the title and body
  document.getElementById('emailstorerejected-logo').src =
    templateData.logo || '/assets/images/socialmedialogo/default-logo.png';

  document.getElementById('emailstorerejected-title').textContent = templateData.title || '';
  document.getElementById('emailstorerejected-title2').textContent = templateData.title || '';
  document.getElementById('emailstorerejected-body').textContent =
    templateData.body ||
    '';

  document.getElementById('emailstorerejected-sectionuscontact').textContent =
    templateData.section_text || '';

  // Update policy links
  document.getElementById('emailstorerejected-privacypolicy').style.display = templateData.privacy_policy
    ? 'inline'
    : 'none';

  document.getElementById('emailstorerejected-refundpolicy').style.display = templateData.refund_policy ? 'inline' : 'none';
  document.getElementById('emailstorerejected-cancellationpolicy').style.display = templateData.cancellation_policy
    ? 'inline'
    : 'none';
  document.getElementById('emailstorerejected-contactus').style.display = templateData.contact_us ? 'inline' : 'none';

  // Update social media links
  document.getElementById('emailstorerejected-twitterlink').style.display = templateData.twitter ? 'inline' : 'none';
  document.getElementById('emailstorerejected-linkdlnlink').style.display = templateData.linkedIn ? 'inline' : 'none';
  document.getElementById('emailstorerejected-instagramlink').style.display = templateData.instagram ? 'inline' : 'none';
  document.getElementById('emailstorerejected-facebooklink').style.display = templateData.facebook ? 'inline' : 'none';

  // Update copyright content
  document.getElementById('emailstorerejected-copyrightcontent').textContent =
    templateData.copyright_content || '';
}


function updateEmailStoreWaiting(templateData) {
  // Update the title and body
  document.getElementById('emailstorewaiting-logo').src =
    templateData.logo || '/assets/images/socialmedialogo/default-logo.png';

  document.getElementById('emailstorewaiting-title').textContent = templateData.title || '';
  document.getElementById('emailstorewaiting-title2').textContent = templateData.title || '';
  document.getElementById('emailstorewaiting-body').textContent =
    templateData.body ||
    '';

  document.getElementById('emailstorewaiting-sectionuscontact').textContent =
    templateData.section_text || '';

  // Update policy links
  document.getElementById('emailstorewaiting-privacypolicy').style.display = templateData.privacy_policy
    ? 'inline'
    : 'none';

  document.getElementById('emailstorewaiting-refundpolicy').style.display = templateData.refund_policy ? 'inline' : 'none';
  document.getElementById('emailstorewaiting-cancellationpolicy').style.display = templateData.cancellation_policy
    ? 'inline'
    : 'none';
  document.getElementById('emailstorewaiting-contactus').style.display = templateData.contact_us ? 'inline' : 'none';

  // Update social media links
  document.getElementById('emailstorewaiting-twitterlink').style.display = templateData.twitter ? 'inline' : 'none';
  document.getElementById('emailstorewaiting-linkdlnlink').style.display = templateData.linkedIn ? 'inline' : 'none';
  document.getElementById('emailstorewaiting-instagramlink').style.display = templateData.instagram ? 'inline' : 'none';
  document.getElementById('emailstorewaiting-facebooklink').style.display = templateData.facebook ? 'inline' : 'none';

  // Update copyright content
  document.getElementById('emailstorewaiting-copyrightcontent').textContent =
    templateData.copyright_content || '';
}


function updateEmailVendorSwitch(templateData) {
  // Update the title and body
  document.getElementById('emailvendorswitch-logo').src =
    templateData.logo || '/assets/images/socialmedialogo/default-logo.png';

  document.getElementById('emailvendorswitch-title').textContent = templateData.title || '';
  document.getElementById('emailvendorswitch-body').textContent =
    templateData.body ||
    '';

  document.getElementById('emailvendorswitch-sectionuscontact').textContent =
    templateData.section_text || '';

  // Update policy links
  document.getElementById('emailvendorswitch-privacypolicy').style.display = templateData.privacy_policy
    ? 'inline'
    : 'none';

  document.getElementById('emailvendorswitch-refundpolicy').style.display = templateData.refund_policy ? 'inline' : 'none';
  document.getElementById('emailvendorswitch-cancellationpolicy').style.display = templateData.cancellation_policy
    ? 'inline'
    : 'none';
  document.getElementById('emailvendorswitch-contactus').style.display = templateData.contact_us ? 'inline' : 'none';

  // Update social media links
  document.getElementById('emailvendorswitch-twitterlink').style.display = templateData.twitter ? 'inline' : 'none';
  document.getElementById('emailvendorswitch-linkdlnlink').style.display = templateData.linkedIn ? 'inline' : 'none';
  document.getElementById('emailvendorswitch-instagramlink').style.display = templateData.instagram ? 'inline' : 'none';
  document.getElementById('emailvendorswitch-facebooklink').style.display = templateData.facebook ? 'inline' : 'none';

  // Update copyright content
  document.getElementById('emailvendorswitch-copyrightcontent').textContent =
    templateData.copyright_content || '';
}




function fetchWelcomeEmail() {
  fetch('/api/showemail-emailwelcome')
    .then(response => response.json())
    .then(data => {
      if (data.success) {
        updateWelcomeEmail(data.data[0]); // Assuming first item is needed
      } else {
        console.error('Failed to fetch email template data:', data.message);
      }
    })
    .catch(error => {
      console.error('Error fetching email template data:', error);
    });
}


function fetchEmailOtpVerify() {
  fetch('/api/showemail-emailotpverify')
    .then(response => response.json())
    .then(data => {
      if (data.success) {
        updateEmailOtpVerify(data.data[0]); // Assuming first item is needed
      } else {
        console.error('Failed to fetch email template data:', data.message);
      }
    })
    .catch(error => {
      console.error('Error fetching email template data:', error);
    });
}


function fetchEmailStoreApproved() {
  fetch('/api/showemail-emailstoreapproved')
    .then(response => response.json())
    .then(data => {
      if (data.success) {
        updateEmailStoreApproved(data.data[0]); // Assuming first item is needed
      } else {
        console.error('Failed to fetch email template data:', data.message);
      }
    })
    .catch(error => {
      console.error('Error fetching email template data:', error);
    });
}


function fetchEmailStoreRejected() {
  fetch('/api/showemail-emailstorerejected')
    .then(response => response.json())
    .then(data => {
      if (data.success) {
        updateEmailStoreRejected(data.data[0]); // Assuming first item is needed
      } else {
        console.error('Failed to fetch email template data:', data.message);
      }
    })
    .catch(error => {
      console.error('Error fetching email template data:', error);
    });
}


function fetchEmailStoreWaiting() {
  fetch('/api/showemail-emailstorewaiting')
    .then(response => response.json())
    .then(data => {
      if (data.success) {
        updateEmailStoreWaiting(data.data[0]); // Assuming first item is needed
      } else {
        console.error('Failed to fetch email template data:', data.message);
      }
    })
    .catch(error => {
      console.error('Error fetching email template data:', error);
    });
}


function fetchEmailVendorSwitch() {
  fetch('/api/showemail-emailvendorswitch')
    .then(response => response.json())
    .then(data => {
      if (data.success) {
        updateEmailVendorSwitch(data.data[0]); // Assuming first item is needed
      } else {
        console.error('Failed to fetch email template data:', data.message);
      }
    })
    .catch(error => {
      console.error('Error fetching email template data:', error);
    });
}




// Initialize both functions when DOM is ready
document.addEventListener('DOMContentLoaded', function () {
  fetchWelcomeEmail();
  fetchEmailOtpVerify();
  fetchEmailStoreApproved();
  fetchEmailStoreRejected();
  fetchEmailStoreWaiting();
  fetchEmailVendorSwitch();
});
