<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('first_name')->nullable();
            $table->string('last_name')->nullable();
            $table->string('email')->nullable()->index();
            $table->string('login_type')->nullable();
            $table->string('username')->nullable();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->text('two_factor_secret')->nullable();
            $table->text('two_factor_recovery_codes')->nullable();
            $table->timestamp('two_factor_confirmed_at')->nullable();
            $table->string('mobile')->nullable();
            $table->string('device_token')->nullable();
            $table->string('otp')->nullable();
            $table->text('image')->nullable();
            $table->integer('status')->default(1);
            $table->rememberToken();
            $table->text('country_code')->nullable();
            $table->text('role')->nullable();
            $table->integer('is_online')->default(0);
            $table->timestamp('last_seen')->nullable();
            $table->integer('verify_otp')->default(0);
            $table->text('stripe_customer_id')->nullable();
            $table->text('country_flag')->nullable();
            $table->integer('mobile_verify_otp')->default(0);
            $table->timestamps(); // created_at and updated_at
        });

        DB::table('users')->insert([
    'first_name' => 'Nlytical',
    'last_name' => 'User',
    'email' => 'nlyticaladmin@gmail.com',
    'login_type' => 'email',
    'username' => 'nlytical_user',
    'password' =>'$2y$10$XxNaDDEkyTvfg4cY6tETwer0qa.0259e4oaITwjhF5zfF3bNX5q4q', // Or use a pre-hashed one
    'mobile' => '98745632101',
    'image' => '1742375188_user_image.png',
    'status' => 1,
    'role' => 'user', // or 'admin', if you're using roles
    'country_code' => '+91',
    'created_at' => now(),
    'updated_at' => now(),
]);
    }
    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
    }
};
