<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('settings', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary Key
            $table->text('nearby_service_km')->nullable(); // Distance range in km
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });


        // Insert default admin record
        DB::table('settings')->insert([
            'id' => 1,
            'nearby_service_km' => '10',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('settings');
    }
};
