<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;


return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_settings', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // Primary key: int(11) unsigned
            $table->text('inputs')->nullable();                  // text nullable
            $table->integer('status')->default(0);               // int(11), default 0
            $table->timestamp('created_at')->nullable();         // timestamp nullable
            $table->timestamp('updated_at')->nullable();         // timestamp nullable
        });

        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 1,
            'inputs' => 'slider',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 2,
            'inputs' => 'categories',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 3,
            'inputs' => 'cards',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 4,
            'inputs' => 'sponserstores',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 5,
            'inputs' => 'cities',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 6,
            'inputs' => 'banner',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 7,
            'inputs' => 'perfectstore',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 8,
            'inputs' => 'testimonials',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('home_settings')->insert([
            'id' => 9,
            'inputs' => 'subscriptions',
            'status' => 1,
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }




    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_settings');
    }
};
