<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('home_perfectstore', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned AUTO_INCREMENT
            $table->integer('service_id', false, true)->nullable(); // int(11) unsigned nullable
            $table->text('title')->nullable();
            $table->text('subtext')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('home_perfectstore');
    }
};
