<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('faq', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned
            $table->text('question')->nullable();
            $table->text('answer')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('faq')->insert([
            'id' => 1,
            'question' => 'What is Nylitical?',
            'answer' => 'Nylitical is a comprehensive service platform that connects users with professionals and service providers for a variety of needs, ranging from home repairs to personal care.',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('faq')->insert([
            'id' => 2,
            'question' => 'How does Nylitical work?',
            'answer' => 'Simply create an account, browse through the list of available services, choose a service provider, and book an appointment at your convenience.',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('faq');
    }
};
