<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('currencies', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned
            $table->text('currency')->nullable(); // e.g. USD, INR
            $table->text('name')->nullable(); // e.g. US Dollar, Indian Rupee
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('currencies')->insert([
            'id' => 1,
            'currency' => '€',
            'name' => 'EUR',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('currencies')->insert([
            'id' => 2,
            'currency' => '£',
            'name' => 'GBP',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('currencies')->insert([
            'id' => 3,
            'currency' => '₹',
            'name' => 'INR',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);

        // Insert default admin record
        DB::table('currencies')->insert([
            'id' => 4,
            'currency' => 'A$',
            'name' => 'AUD',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('currencies')->insert([
            'id' => 5,
            'currency' => '$',
            'name' => 'USD',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('currencies');
    }
};
