<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;


return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_reviews', function (Blueprint $table) {
            $table->integer('id', false, true)->autoIncrement(); // int(11) unsigned
            $table->text('review_text')->nullable();
            $table->text('review_star')->nullable();
            $table->text('full_name')->nullable();
            $table->text('client_role')->nullable();
            $table->text('image')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });

        // Insert default admin record
        DB::table('client_reviews')->insert([
            'id' => 1,
            'review_text' => 'The ambiance and service at [Restaurant Name] were exceptional! The outdoor seating made for a perfect evening, and the food was absolutely delicious. A must-visit for food lovers!',
            'review_star' => '5',
            'full_name' => 'Emily Carter',
            'client_role' => 'Food Blogger',
            'image' => '1742290174.jpg',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('client_reviews')->insert([
            'id' => 2,
            'review_text' => 'The team at [Hospital Name] provided world-class care. From the nurses to the doctors, everyone was incredibly compassionate and attentive. I felt well taken care of throughout my treatment.',
            'review_star' => '4',
            'full_name' => 'Dr. Michael Reynolds',
            'client_role' => 'Medical Professional',
            'image' => '1742290233.jpg',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);


        // Insert default admin record
        DB::table('client_reviews')->insert([
            'id' => 3,
            'review_text' => 'offers some of the freshest ingredients ive ever tasted. Their commitment to quality and sustainability is truly commendable. Highly recommended for food lovers!',
            'review_star' => '4',
            'full_name' => 'Sarah Thompson',
            'client_role' => 'Food Critic',
            'image' => '1742290293.jpg',
            'created_at' => '2024-09-24 10:35:59',
            'updated_at' => '2025-03-19 09:06:28',
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_reviews');
    }
};
