<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Schema;
use App\Models\MailSetup;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\File;
use Illuminate\Contracts\Http\Kernel;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    public function boot()
    {
        app()->booted(function () {
            $request = request();
            $requestUri = $request->getRequestUri(); // Gets the full request URI, including slashes

            $allowedUris = [
                '/api/validate-purchase',
                '/api/verified-token',
                '/nlytical-install-1',
                '/nlytical-install-2',
                '/nlytical-install-3',
                '/nlytical-install-4',
                '/',
                '/api/check-extensions'
            ];

            if (in_array($requestUri, $allowedUris)) {
                return;
            }

            if (!$this->verifyToken()) {
                abort(400, 'Unauthorized or invalid token.');
            }
        });
    }


    private function verifyToken(): bool
    {
        try {
            $tokenFilePath = base_path('token/validatedToken.txt');

            if (!File::exists($tokenFilePath)) {
                Log::error("Token file not found: " . $tokenFilePath);
                return false;
            }

            $token = File::get($tokenFilePath);

            $apiUrl = "https://validator.whoxachat.com/verify_new";


            $response = Http::post($apiUrl, [
                "server_ip" => request()->ip(),
                "mac_address" => exec('getmac'),
                "token" => trim($token),
            ]);

            $data = $response->json();

            if (!isset($data['success']) || !$data['success']) {
                Log::error("Token verification failed");
                return false;
            }

            return true;
        } catch (\Exception $e) {
            Log::error('Verification Error:', ['exception' => $e->getMessage()]);
            return false;
        }
    }
}
