<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Fortify\TwoFactorAuthenticatable;
use Laravel\Jetstream\HasProfilePhoto;
use Laravel\Sanctum\HasApiTokens;
use PHPOpenSourceSaver\JWTAuth\Contracts\JWTSubject;



class User extends Authenticatable implements JWTSubject
{
    use HasApiTokens;
    use HasFactory;
    // use HasProfilePhoto;
    use Notifiable;
    // use TwoFactorAuthenticatable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $table = 'users';
    protected $guard = 'admin';
    protected $fillable = [
        'id',
        'first_name',
        'last_name',
        'email',
        'login_type',
        'username',
        'email_verified_at',
        'password',
        'mobile',
        'dob',
        'gender',
        'device_token',
        'otp',
        'image',
        'status',
        'wallet_balance',
        'loyalty_points',
        'remember_token',
        'role',
        'created_at',
        'updated_at',
        'country_code',
        'refer_code',
        'user_refer_code',
        'ip_address',
        'guest_user',
        'verify_otp',
        'country_flag',
        'mobile_verify_otp',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'two_factor_recovery_codes',
        'two_factor_secret',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array<int, string>
     */
    protected $appends = [
        'profile_photo_url',
    ];

    // User.php
    public function getProfilePhotoUrlAttribute()
    {
        return $this->image
            ? url('assets/images/users_images/' . $this->image)
            : url('assets/images/users_images/default_user.jpg');
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }
}
