<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SubCategory extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'sub_categories';

    protected $fillable = [
        'id',
        'category_id',
        'subcategory_name',
        'created_at',
        'updated_at',
    ];

    // Define the relationship to the Category model
    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }

    public function services()
    {
        return $this->hasMany(Service::class, 'subcategory_id'); // Adjust the relationship based on your model
    }
}
