<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IndexPerfectStore extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'home_perfectstore';

    protected $fillable = [
        'id',
        'service_id',
        'title',
        'subtext',
        'created_at',
        'updated_at',
    ];

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }
}
