<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class IndexCards extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'home_cards';

    protected $fillable = [
        'id',
        'subcategory_id',
        'title',
        'image',
        'created_at',
        'updated_at',
    ];

    public function subcategory()
    {
        return $this->belongsTo(SubCategory::class, 'subcategory_id');
    }
}
