<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GoalPaymentHistory extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'goal_payment_history';

    protected $fillable = [
        'id',
        'goal_id',
        'service_id',
        'campaign_id',
        'vendor_id',
        'payment_mode',
        'price',
        'end_date',
        'created_at',
        'updated_at',
        'end_date_do',

    ];

    public function goal()
    {
        return $this->belongsTo(Goals::class, 'goal_id', 'id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id', 'id');
    }


    public function vendor()
    {
        return $this->belongsTo(User::class, 'vendor_id', 'id');
    }
}
