<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Campaign extends Model
{
    use HasFactory;
    protected $guard = 'admin';
    protected $table = 'campaign';

    protected $fillable = [
        'id',
        'vendor_id',
        'service_id',
        'lat',
        'lon',
        'address',
        'campaign_name',
        'area_distance',
        'created_at',
        'updated_at',
    ];

    public function vendor()
    {
        return $this->belongsTo(User::class, 'vendor_id');
    }

    public function service()
    {
        return $this->belongsTo(Service::class, 'service_id');
    }
}
