<?php

namespace App\Http\Controllers;

use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class LoginController extends Controller
{
    // index
    public function index()
    {
        return view('auth.login');
    }


    // login
    public function login(Request $request)
    {

        $rules = [
            'email' => 'required',
            'password' => 'required',
        ];

        $customMessages = [
            'email.required' => 'Please enter your email',
            'password.required' => 'Please enter your password',
        ];

        $this->validate($request, $rules, $customMessages);

        if (Auth::guard('admin')->attempt(['email' => $request->email, 'password' => $request->password])) {
            return redirect()->route('dashboard-list');
        } else {
            return back()->with('error', 'Wrong credentials, please try again.');
        }
    }


    // logout
    public function logout()
    {
        Auth::guard('admin')->logout();
        return redirect()->route('login');
    }


    public function markNotificationsRead(Request $request)
    {
        // Validate the request
        $request->validate([
            'notificationIds' => 'required|array',
            'notificationIds.*' => 'integer',
        ]);

        // Update notify_count for the specified services
        Service::whereIn('id', $request->notificationIds)
            ->update(['notify_count' => 1]);

        return response()->json(['success' => true, 'message' => 'Notifications marked as read']);
    }
}
