<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\EmailOtpVerify;
use App\Models\EmailStoreApproved;
use App\Models\EmailStoreRejected;
use App\Models\EmailStoreWaiting;
use App\Models\EmailVendorSwitch;
use App\Models\EmailWelcome;


class WebApiController extends Controller
{
    // showEmailWelcome
    public function showEmailWelcome()
    {
        $baseUrl = rtrim(asset('assets/images/socialmedialogo/'), '/') . '/'; // Ensure proper trailing slash
        $emails = EmailWelcome::get()->map(function ($email) use ($baseUrl) {
            $email->logo = $baseUrl . $email->logo; // Prepend the base URL to the logo
            return $email;
        });

        return response([
            'success' => true,
            'message' => 'Success...!',
            'data' => $emails,
        ]);
    }


    // showEmailOtpVerify
    public function showEmailOtpVerify()
    {
        $baseUrl = rtrim(asset('assets/images/socialmedialogo/'), '/') . '/'; // Ensure proper trailing slash
        $emails = EmailOtpVerify::get()->map(function ($email) use ($baseUrl) {
            $email->logo = $baseUrl . $email->logo; // Prepend the base URL to the logo
            return $email;
        });

        return response([
            'success' => true,
            'message' => 'Success...!',
            'data' => $emails,
        ]);
    }


    // showEmailStoreApproved
    public function showEmailStoreApproved()
    {
        $baseUrl = rtrim(asset('assets/images/socialmedialogo/'), '/') . '/'; // Ensure proper trailing slash
        $emails = EmailStoreApproved::get()->map(function ($email) use ($baseUrl) {
            $email->logo = $baseUrl . $email->logo; // Prepend the base URL to the logo
            return $email;
        });

        return response([
            'success' => true,
            'message' => 'Success...!',
            'data' => $emails,
        ]);
    }


    // showEmailStoreRejected
    public function showEmailStoreRejected()
    {
        $baseUrl = rtrim(asset('assets/images/socialmedialogo/'), '/') . '/'; // Ensure proper trailing slash
        $emails = EmailStoreRejected::get()->map(function ($email) use ($baseUrl) {
            $email->logo = $baseUrl . $email->logo; // Prepend the base URL to the logo
            return $email;
        });

        return response([
            'success' => true,
            'message' => 'Success...!',
            'data' => $emails,
        ]);
    }


    // showEmailStoreWaiting
    public function showEmailStoreWaiting()
    {
        $baseUrl = rtrim(asset('assets/images/socialmedialogo/'), '/') . '/'; // Ensure proper trailing slash
        $emails = EmailStoreWaiting::get()->map(function ($email) use ($baseUrl) {
            $email->logo = $baseUrl . $email->logo; // Prepend the base URL to the logo
            return $email;
        });

        return response([
            'success' => true,
            'message' => 'Success...!',
            'data' => $emails,
        ]);
    }


    // showEmailVendorSwitch
    public function showEmailVendorSwitch()
    {
        $baseUrl = rtrim(asset('assets/images/socialmedialogo/'), '/') . '/'; // Ensure proper trailing slash
        $emails = EmailVendorSwitch::get()->map(function ($email) use ($baseUrl) {
            $email->logo = $baseUrl . $email->logo; // Prepend the base URL to the logo
            return $email;
        });

        return response([
            'success' => true,
            'message' => 'Success...!',
            'data' => $emails,
        ]);
    }
}
