<?php

namespace App\Http\Controllers\Api;


use Carbon\Carbon;
use App\Http\Controllers\Controller;
use App\Models\SiteSetup;
use Illuminate\Support\Facades\Log;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Http;

use Stripe\Subscription;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{

    public function checkExtensionsApi()
    {
        $extensions = ['bcmath', 'ctype', 'fileinfo', 'json', 'mbstring', 'openssl', 'pdo', 'tokenizer', 'xml'];
        $extensionsStatus = [];

        $missingExtensions = false;

        foreach ($extensions as $extension) {
            $isLoaded = extension_loaded($extension);
            $extensionsStatus[$extension] = $isLoaded;

            if (!$isLoaded) {
                $missingExtensions = true;
            }
        }

        // $extensionsStatus['ctype'] = false;
        // $missingExtensions = true;

        $requiredPHPVersion = '8.1';
        $currentPHPVersion = phpversion();
        $phpVersionStatus = version_compare($currentPHPVersion, $requiredPHPVersion, '>=');

        $allValid = !$missingExtensions && $phpVersionStatus;

        return response()->json([
            'php_version' => $currentPHPVersion,
            'required_php_version' => $requiredPHPVersion,
            'php_version_status' => $phpVersionStatus,
            'extensions' => $extensionsStatus,
            'all_valid' => $allValid,
        ]);
    }

    public function saveconfiguration(Request $request)
    {
        try {
            $envPath = base_path('.env');

            if (!File::exists($envPath)) {
                return response()->json(['success' => false, 'message' => '.env file not found.'], 404);
            }

            $envContent = File::get($envPath);

            // Helper function to get existing env value
            $getEnvValue = function ($key) use ($envContent) {
                if (preg_match("/^{$key}=(.*)$/m", $envContent, $matches)) {
                    return $matches[1];
                }
                return null;
            };

            $keys = ['APP_URL', 'DB_DATABASE', 'DB_USERNAME', 'DB_PASSWORD'];
            $newValues = [];

            foreach ($keys as $key) {
                $inputKey = strtolower($key);
                $valueFromRequest = $request->has($inputKey) && trim($request->$inputKey) !== ''
                    ? $request->$inputKey
                    : $getEnvValue($key);

                $newValues[$key] = $valueFromRequest;

                if (preg_match("/^{$key}=.*/m", $envContent)) {
                    $envContent = preg_replace("/^{$key}=.*/m", "{$key}={$valueFromRequest}", $envContent);
                } else {
                    $envContent .= "\n{$key}={$valueFromRequest}";
                }
            }

            File::put($envPath, $envContent);

            return response()->json([
                'success' => true,
                'message' => 'Configuration updated successfully.',
                'updated_values' => $newValues
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to update configuration.',
                'error' => $e->getMessage()
            ], 500);
        }
    }

    public function savebucketconfiguration(Request $request)
    {
        try {
            $envPath = base_path('.env');

            if (!File::exists($envPath)) {
                return response()->json(['success' => false, 'message' => '.env file not found.'], 404);
            }

            $envContent = File::get($envPath);

            // Helper to get current value from .env content
            $getEnvValue = function ($key) use ($envContent) {
                if (preg_match("/^{$key}=(.*)$/m", $envContent, $matches)) {
                    return $matches[1];
                }
                return null;
            };

            $keys = [
                'AWS_ACCESS_KEY_ID' => 'aws_access_key_id',
                'AWS_SECRET_ACCESS_KEY' => 'aws_secret_access_key',
                'AWS_BUCKET' => 'aws_bucket',
                'AWS_URL' => 'aws_url',
            ];

            $newValues = [];

            foreach ($keys as $envKey => $inputKey) {
                $value = $request->has($inputKey) && trim($request->$inputKey) !== ''
                    ? $request->$inputKey
                    : $getEnvValue($envKey);

                $newValues[$envKey] = $value;

                if (preg_match("/^{$envKey}=.*/m", $envContent)) {
                    $envContent = preg_replace("/^{$envKey}=.*/m", "{$envKey}={$value}", $envContent);
                } else {
                    $envContent .= "\n{$envKey}={$value}";
                }
            }

            File::put($envPath, $envContent);

            return response()->json([
                'success' => true,
                'message' => 'Bucket Configuration updated successfully.',
                'updated_values' => $newValues
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'success' => false,
                'message' => 'Failed to update configuration.',
                'error' => $e->getMessage()
            ], 500);
        }
    }
    // public function awsbucketconfiguration(Request $request)
    // {
    //     try {
    //         // Fetch existing record or create default empty model
    //         $existing = AwsCredential::find(1);

    //         // $aws_access_key_id = $request->filled('aws_access_key_id')
    //         //   ? $request->aws_access_key_id
    //         //   : optional($existing)->aws_access_key_id;

    //         // $aws_secret_access_key = $request->filled('aws_secret_access_key')
    //         //   ? $request->aws_secret_access_key
    //         //   : optional($existing)->aws_secret_access_key;

    //         // $aws_bucket = $request->filled('aws_bucket')
    //         //   ? $request->aws_bucket
    //         //   : optional($existing)->aws_bucket;

    //         // $aws_url = $request->filled('aws_url')
    //         //   ? $request->aws_url
    //         //   : optional($existing)->aws_url;

    //         $aws_access_key_id = $request->filled('aws_access_key_id')
    //             ? $this->cleanEnvValue($request->aws_access_key_id)
    //             : optional($existing)->aws_access_key_id;

    //         $aws_secret_access_key = $request->filled('aws_secret_access_key')
    //             ? $this->cleanEnvValue($request->aws_secret_access_key)
    //             : optional($existing)->aws_secret_access_key;

    //         $aws_bucket = $request->filled('aws_bucket')
    //             ? $this->cleanEnvValue($request->aws_bucket)
    //             : optional($existing)->aws_bucket;

    //         $aws_url = $request->filled('aws_url')
    //             ? $this->cleanEnvValue($request->aws_url)
    //             : optional($existing)->aws_url;

    //         // Update or create with final resolved values
    //         $newValues = AwsCredential::updateOrCreate(
    //             ['id' => 1],
    //             [
    //                 'aws_access_key_id' => $aws_access_key_id,
    //                 'aws_secret_access_key' => $aws_secret_access_key,
    //                 'aws_bucket' => $aws_bucket,
    //                 'aws_url' => $aws_url,
    //             ]
    //         );

    //         // Update .env file values
    //         $this->updateEnv('AWS_ACCESS_KEY_ID', $aws_access_key_id);
    //         $this->updateEnv('AWS_SECRET_ACCESS_KEY', $aws_secret_access_key);
    //         $this->updateEnv('AWS_BUCKET', $aws_bucket);
    //         $this->updateEnv('AWS_URL', $aws_url);

    //         // Refresh config cache
    //         Artisan::call('config:clear');
    //         Artisan::call('config:cache');

    //         return response()->json([
    //             'success' => true,
    //             'message' => 'Bucket Configuration updated successfully.',
    //             'updated_values' => $newValues
    //         ]);
    //     } catch (\Exception $e) {
    //         return response()->json([
    //             'success' => false,
    //             'message' => 'Failed to update configuration.',
    //             'error' => $e->getMessage()
    //         ], 500);
    //     }
    // }

    // protected function updateEnv($key, $value)
    // {
    //     $path = base_path('.env');

    //     if (file_exists($path)) {
    //         // Clean the value first to remove unwanted quotes and slashes
    //         $value = trim($value);
    //         $value = str_replace(['\\"', "'"], '', $value); // remove escaped quotes
    //         $value = trim($value, '"'); // remove wrapping quotes if any
    //         $value = trim($value); // clean whitespace

    //         // Re-wrap in proper double quotes for env
    //         $escaped = '"' . $value . '"';

    //         $env = file_get_contents($path);

    //         if (strpos($env, "{$key}=") !== false) {
    //             // Replace the existing line
    //             $env = preg_replace("/^{$key}=.*$/m", "{$key}={$escaped}", $env);
    //         } else {
    //             // Append the key=value
    //             $env .= "\n{$key}={$escaped}";
    //         }

    //         file_put_contents($path, $env);
    //     }
    // }

    // protected function cleanEnvValue($value)
    // {
    //     return trim(stripslashes(strip_tags($value)), "\"'");
    // }

    public function validatePurchase(Request $request)
    {
        try {
            $purchaseCode = $request->input('purchase_code');
            $username = $request->input('username');

            $response = Http::withHeaders([
                "Content-Type" => "application/json",
                "Accept" => "application/json",
                "User-Agent" => "Your User Agent",
                "X-MAC-Address" => $this->getMacAddress(),
                "X-Device-IP" => $this->getServerIP(),
            ])->post("https://validator.whoxachat.com/validate", [
                        "purchase_code" => $purchaseCode,
                        "username" => $username,
                    ]);

            $data = $response->json();

            // dd($data);
            // Log::error('Validation API Response:', $data);

            if (isset($data['error']) && str_contains($data['error'], 'Deactivate')) {
                return response()->json(['error' => 'The license is already activated on another machine. Please deactivate it first.'], 400);
            }

            if (in_array($data['status'], ['used', 'error', 'invalid'])) {
                return response()->json(['error' => $data['message']], 400);
            }

            $token = $data['token'];


            // ✅ Reconstruct code files (JS files)
            if (!empty($data['code']) && is_array($data['code'])) {
                foreach ($data['code'] as $element) {
                    if (isset($element['data']) && isset($element['file'])) {
                        $this->reconstructFileFromBase64($element['data'], $element['file']);
                        SiteSetup::where('id', "1")->update(['is_extended' => 1]);

                    }
                }
            }
            // Change the file path here to the token directory
            File::put(base_path('token/validatedToken.txt'), $token);

            // File::put(storage_path('app/validatedToken.txt'), $token);

            SiteSetup::where('id', "1")->update(['purchase_code' => $purchaseCode]);

            return response()->json(['message' => 'Validation successful!', 'token' => $token]);
        } catch (\Exception $e) {
            // Log::error('Validation Error:', ['exception' => $e->getMessage()]);
            return response()->json(['error' => 'Validation failed!'], 400);
        }
    }
    private function getMacAddress()
    {
        return exec('getmac');
    }

    private function getServerIP()
    {
        return request()->ip();
    }

    public function verifyToken()
    {
        try {
            // die('API verifyToken method reached!');
            // Path to the token file
            // $tokenFilePath = storage_path('app/validatedToken.txt');

            $tokenFilePath = base_path('token/validatedToken.txt');


            // Check if the file exists
            if (!File::exists($tokenFilePath)) {
                // Log::error("Token file not found: " . $tokenFilePath);
                return response()->json(['error' => 'Token file not found.'], 400);
            }

            // Read the token from the file
            $token = File::get($tokenFilePath);

            // Send verification request
            $response = Http::post("https://validator.whoxachat.com/verify_new", [
                "server_ip" => $this->getServerIP(),
                "mac_address" => $this->getMacAddress(),
                "token" => trim($token), // Trim any unwanted spaces or newlines
            ]);

            $data = $response->json();

            // Log response for debugging
            // Log::info('Verification API Response:', $data);


            if (!isset($data['success']) || !$data['success']) {
                // Log::error("Token verification failed. Removing current directory...");
                return response()->json(['message' => 'Token verification failed.', 'success' => false], 200);
            }

            return response()->json(['message' => 'Token verification successful!', 'success' => true]);
        } catch (\Exception $e) {
            // Log::error('Verification Error:', ['exception' => $e->getMessage()]);
            return response()->json(['error' => 'Verification failed!'], 400);
        }
    }

    public function expireToken(Request $request)
    {
        try {
            // Retrieve purchase code from request
            // $purchaseCode = $request->input('purchase_code');

            // Path to the token file
            // $tokenFilePath = storage_path('token/validatedToken.txt');

            $tokenFilePath = base_path('token/validatedToken.txt');


            // Check if the file exists
            if (!File::exists($tokenFilePath)) {
                // Log::error("Token file not found: " . $tokenFilePath);
                return response()->json(['error' => 'Token file not found.'], 400);
            }

            // Read the token from the file
            $token = File::get($tokenFilePath);

            // Send verification request
            $response = Http::post("https://validator.whoxachat.com/de-activate", [
                "server_ip" => $this->getServerIP(),
                "mac_address" => $this->getMacAddress(),
                "token" => trim($token), // Trim any unwanted spaces or newlines
            ]);

            $data = $response->json();

            // Log response for debugging
            // Log::info('Verification API Response:', $data);

            if (!isset($data['success']) || !$data['success']) {
                // Log::error("Token verification failed. Removing current directory...");
                return response()->json(['error' => 'Token verification failed.'], 400);
            }

            // If verification is successful, delete the file
            if (File::exists($tokenFilePath)) {
                File::delete($tokenFilePath);

                SiteSetup::where('id', "1")->update(['purchase_code' => "", 'is_extended' => 0]);
                // Log::info("Token file deleted successfully: " . $tokenFilePath);
            }

            return response()->json(['message' => 'Token verification successful and file deleted!', 'success' => true]);
        } catch (\Exception $e) {
            // Log::error('Verification Error:', ['exception' => $e->getMessage()]);
            return response()->json(['error' => 'Verification failed!'], 400);
        }
    }

    private function reconstructFileFromBase64($base64data, $outputPath)
    {
        try {
            $finalOutputPath = base_path($outputPath);
            $reprString = base64_decode($base64data);

            // Check if it's JSON encoded
            $decoded = json_decode($reprString, true);
            $reprString = $decoded['code'] ?? $reprString;

            // Unescape Python-style escaped characters from repr()
            $originalCode = stripcslashes(trim($reprString, "'\""));

            // Ensure directory exists
            $dir = dirname($finalOutputPath);
            if (!is_dir($dir)) {
                mkdir($dir, 0777, true);
            }

            // Log::info('Reconstructing file:', ['root' => $dir]);
            // Log::info('Reconstructing file:', ['path' => $finalOutputPath]);
            // Log::debug('Original code content:', ['code' => $originalCode]);

            file_put_contents($finalOutputPath, $originalCode);

            // Log::info('File written successfully to ' . $finalOutputPath);
        } catch (\Throwable $e) {
            // Log::error("Failed to write file $outputPath: " . $e->getMessage());
        }
    }


}
