<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Controllers\BaseController;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Lead;
use App\Models\GoalPaymentHistory;
use App\Models\UserSubscriptionHistory;
use App\Models\UserSubscription;
use App\Models\SubscriptionPlan;
use App\Models\GoalPayment;
use App\Models\User;
use App\Models\Service;
use App\Models\Goals;
use App\Models\SiteSetup;
use Carbon\Carbon;
use App\Models\Campaign;
use Stripe\Stripe;
use Stripe\PaymentIntent;
use Stripe\StripeClient;
use Illuminate\Support\Facades\Auth;

class SubScriberController extends BaseController
{

    //  /var/www/nlytical/app/Http/Controllers/Api/SubScriberController.php
    // paymentSuccess
    public function paymentSuccess(Request $request)
    {
        $user = Auth::user();
        $user_id = $user->id;
        $plan_name = $request->input('plan_name');
        $payment_mode = $request->input('payment_mode');
        $price = $request->input('price');
        $subscription_id = $request->input('subscription_id');


        if (
            !$plan_name || !$payment_mode || !$price || !$subscription_id
        ) {
            return response()->json([
                'status' => false,
                'message' => 'Invalid input data',
            ], 400);
        }

        $check_plan = SubscriptionPlan::where('id', $subscription_id)->first();
        if (!$check_plan) {
            return response()->json([
                'status' => false,
                'message' => 'Subscription id not found',
            ], 404);
        }

        // if (
        //     $plan_name == "Yearly"
        // ) {
        //     $expire_date = now()->addYear()->format('Y-m-d');
        // } else {
        //     $expire_date = now()->addMonth()->format('Y-m-d');
        // }

        $start_date = now();

        $duration = $check_plan->duration; // e.g. "1 Month", "3 Month", "1 Year"
        $expire_date = $start_date;

        if ($duration) {
            // Extract numeric value and unit from duration string
            preg_match('/(\d+)\s*(Month|Year)/i', $duration, $matches);

            if (isset($matches[1]) && isset($matches[2])) {
                $value = (int)$matches[1];
                $unit = strtolower($matches[2]);

                if ($unit == 'month') {
                    $expire_date = $start_date->copy()->addMonths($value);
                } elseif ($unit == 'year') {
                    $expire_date = $start_date->copy()->addYears($value);
                }
            }
        }


        // $start_date = now()->format('Y-m-d');
        // $start_date = $start_date->format('Y-m-d');
        $expire_date = $expire_date->format('Y-m-d');
        $start_date_do = $start_date->format('Y-m-d');

        $check_user_subscription = UserSubscription::where('user_id', $user_id)->first();

        if ($check_user_subscription) {
            // Update the existing subscription and reset status to 0
            $check_user_subscription->update([
                'plan_name' => $plan_name,
                'price' => $price,
                'payment_mode' => $payment_mode,
                'start_date' => $start_date_do,
                'expire_date' => $expire_date,
                'status' => 0, // reset status
                'subscription_id' => $subscription_id,
            ]);
        } else {
            // Create new subscription if not found
            $check_user_subscription = UserSubscription::create([
                'user_id' => $user_id,
                'plan_name' => $plan_name,
                'price' => $price,
                'payment_mode' => $payment_mode,
                'start_date' => $start_date_do,
                'expire_date' => $expire_date,
                'status' => 0,
                'subscription_id' => $subscription_id,
            ]);
        }

        UserSubscriptionHistory::create([

            'user_id' => $user_id,
            'plan_name' => $plan_name,
            'price' => $price,
            'payment_mode' => $payment_mode,
            'start_date' => $start_date_do,
            'expire_date' => $expire_date,
            'status' => 0,
            'subscription_id' => $subscription_id,

        ]);

        $FcmToken = User::select('device_token')->where('id', $user_id)->first()->device_token;

        $data = [
            'title' => "Subcription Succesfull",
            'message' => "you have successfully subscribed to $plan_name",
            'type' => "subscriber",
            'booking_id' => 0,
            'order_id' => 0,
        ];
        $baseController = new BaseController();
        $baseController->sendNotification(new Request($data), $FcmToken);

        // dd($data);

        // Check if the subscription was successfully created or updated
        if ($check_user_subscription) {
            return response()->json([
                'status' => true,
                'message' => 'Payment successful, subscription done',
                'subscription' => [
                    'id' => $check_user_subscription->id,
                    'user_id' => (int)$check_user_subscription->user_id,
                    'plan_name' => $check_user_subscription->plan_name ?? '',
                    'price' => $check_user_subscription->price ?? '',
                    'start_date' => $check_user_subscription->start_date ?? '',
                    'expire_date' => $check_user_subscription->expire_date ?? '',
                    'payment_mode' => $check_user_subscription->payment_mode ?? '',
                    'status' => $check_user_subscription->status ?? 0,
                    'created_at' => $check_user_subscription->created_at,
                    'updated_at' => $check_user_subscription->updated_at,
                    'subscription_id' => $check_user_subscription->subscription_id ?? '',
                ]
            ], 200);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Payment failed, subscription could not be processed',
            ], 500);
        }
    }

    public function goalPaymentSuccess(Request $request)
    {
        $user = Auth::user();
        $vendor_id = $user->id;
        $goal_id = $request->input('goal_id');
        // $vendor_id = $request->input('vendor_id');
        $payment_mode = $request->input('payment_mode');
        $service_id = $request->input('service_id');
        $price = $request->input('price');

        // Validate input data
        if (!$goal_id || !$payment_mode || !$price || !$service_id) {
            return response()->json([
                'status' => false,
                'message' => 'Invalid input data',
            ], 400);
        }

        // Check if vendor exists in users table
        $vendorExists = User::where('id', $vendor_id)->exists();
        if (!$vendorExists) {
            return response()->json([
                'status' => false,
                'message' => 'Vendor not found',
            ], 404);
        }

        // Check if service exists in services table
        $serviceExists = Service::where('id', $service_id)->exists();
        if (!$serviceExists) {
            return response()->json([
                'status' => false,
                'message' => 'Service not found',
            ], 404);
        }

        // Check if goal exists
        $goal_payment = Goals::where('id', $goal_id)->first();
        if (!$goal_payment) {
            return response()->json([
                'status' => false,
                'message' => 'Goal not found',
            ], 404);
        }

        $end_date = $goal_payment->end_date;
        $campaign_id = $goal_payment->campaign_id;

        // $formatted_date = Carbon::createFromFormat('d-m-Y', $end_date)->format('Y-m-d');
        $formatted_date = Carbon::parse($end_date)->format('d-m-Y');


        // dd($formatted_date);


        try {
            // Check if a record with the same goal_id and service_id exists
            $payment = GoalPayment::where('service_id', $service_id)->first();

            if ($payment) {
                // Update existing record
                $payment->vendor_id = $vendor_id;
                $payment->goal_id = $goal_id;
                $payment->payment_mode = $payment_mode;
                $payment->price = $price;
                $payment->end_date_do = $end_date;
                $payment->campaign_id = $campaign_id;
                $payment->end_date = $formatted_date;
                $payment->save();
            } else {
                // Insert new record
                $newPayment = new GoalPayment();
                $newPayment->goal_id = $goal_id;
                $newPayment->vendor_id = $vendor_id;
                $newPayment->payment_mode = $payment_mode;
                $newPayment->service_id = $service_id;
                $newPayment->price = $price;
                $newPayment->end_date_do = $end_date;
                $newPayment->campaign_id = $campaign_id;
                $newPayment->end_date = $formatted_date;
                $newPayment->save();
            }

            GoalPaymentHistory::create([
                'vendor_id' => $vendor_id,
                'goal_id' => $goal_id,
                'payment_mode' => $payment_mode,
                'price' => $price,
                'end_date' => $end_date,
                'campaign_id' => $campaign_id,
                'service_id' => $service_id,
                'end_date_do' => $formatted_date,
            ]);

            // Fetch the updated goal data
            $goalData = Goals::where('id', $goal_id)->first();

            return response()->json([
                'status' => true,
                'message' => 'Payment successful',
                'goal_data' => $goalData, // Returning complete goal data
            ], 200);
        } catch (\Exception $e) {
            return response()->json([
                'status' => false,
                'message' => 'Payment failed: ' . $e->getMessage(),
            ], 500);
        }
    }

    public function subscriptionPlan(Request $request)
    {
        $search = $request->input('search');
        $page = (int) $request->input('page', 1);
        $pageSize = (int) $request->input('pageSize', 10);
        $orderColumn = $request->input('orderColumn', 'id');
        $orderDir = strtoupper($request->input('orderDir', 'DESC'));

        // Whitelist allowed order columns
        $allowedOrderColumns = ['id', 'plan_name', 'price', 'validity_day', 'created_at'];
        if (!in_array($orderColumn, $allowedOrderColumns)) {
            $orderColumn = 'id';
        }
        if (!in_array($orderDir, ['ASC', 'DESC'])) {
            $orderDir = 'DESC';
        }

        $query = SubscriptionPlan::query();

        if (!empty($search)) {
            $query->where('plan_name', 'like', '%' . $search . '%');
        }

        $total = $query->count();

        $plans = $query->orderBy($orderColumn, $orderDir)
            ->skip(($page - 1) * $pageSize)
            ->take($pageSize)
            ->get();

        $siteSetup = SiteSetup::first();
        $defaultCurrency = $siteSetup?->default_currency ?? '';
        $currencyValue = $siteSetup?->currency_value ?? '';
        $currencyDone = $siteSetup?->default_currency_name ?? '';

        $result = [];

        foreach ($plans as $row) {
            $result[] = [
                'id' => (int)$row->id,
                'plan_name' => $row->plan_name ?? '',
                'description' => $row->description ?? '',
                'price' => $row->price ? $defaultCurrency . $row->price : '',
                'duration' => $row->duration ?? '',
                'currency_value' => $currencyValue,
                'subtext' => $row->subtext ?? '',
                'created_at' => $row->created_at ?? '',
                'currency_name' => $currencyDone,
            ];
        }

        return response()->json([
            'status' => !empty($result),
            'message' => !empty($result) ? 'Subscription Plan Found' : 'No Plans Found',
            'subscriptionDetail' => $result,
            'Pagination' => [
                'total_pages' => ceil($total / $pageSize),
                'total_records' => $total,
                'current_page' => $page,
                'records_per_page' => $pageSize,
            ],
        ]);
    }

    // addCampaign
    public function addCampaign(Request $request)
    {
        $user = Auth::user();
        $vendor_id = $user->id;
        $rules = [
            'campaign_name' => 'required',
            // 'vendor_id' => 'required|exists:users,id',
            'service_id' => 'required|exists:services,id',
            'address' => 'required',
            'lat' => 'required',
            'lon' => 'required',
            'area_distance' => 'required',
        ];

        $customMessages = [
            'campaign_name.required' => 'Please enter the campaign name.',
            // 'vendor_id.required' => 'Vendor ID is required.',
            // 'vendor_id.exists' => 'Vendor ID does not exist.',
            'service_id.required' => 'Service ID is required.',
            'service_id.exists' => 'Service ID does not exist.',
            'address.required' => 'Please enter the address.',
            'lat.required' => 'Please enter the latitude.',
            'lon.required' => 'Please enter the longitude.',
            'area_distance.required' => 'Please enter the area distance.',
        ];

        $validator = Validator::make($request->all(), $rules, $customMessages);
        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'message' => $validator->errors()->first(),
            ], 400);
        }

        $campaign = new Campaign();
        $campaign->vendor_id = $vendor_id;
        $campaign->service_id = $request->service_id;
        $campaign->campaign_name = $request->campaign_name;
        $campaign->address = $request->address;
        $campaign->lat = $request->lat;
        $campaign->lon = $request->lon;
        $campaign->area_distance = $request->area_distance;
        $campaign->save();

        return response()->json([
            'status' => true,
            'message' => 'Campaign added successfully!',
            'campaign' => $campaign,
        ], 200);
    }

    // addGoals
    public function addGoals(Request $request)
    {
        $user = Auth::user();
        $user_id = $user->id;
        $rules = [
            'start_date'   => 'required',
            'campaign_id'  => 'required|exists:campaign,id',
            'end_date'     => 'required',
            'days'         => 'required',
            'price'        => 'required',
        ];

        $customMessages = [
            'start_date.required'  => 'Please enter the start date.',
            'end_date.required'    => 'Please enter the end date.',
            'days.required'        => 'Please enter the number of days.',
            'price.required'       => 'Please enter the price.',
            'campaign_id.exists'   => 'The selected campaign does not exist.',
        ];

        $validator = Validator::make($request->all(), $rules, $customMessages);

        if ($validator->fails()) {
            return response()->json([
                'status'  => false,
                'message' => $validator->errors()->first(),
            ], 400);
        }

        // Fetch campaign details
        $campaign = DB::table('campaign')
            ->where('id', $request->campaign_id)
            ->select('id', 'campaign_name', 'address', 'lat', 'lon', 'area_distance')
            ->first();

        if (!$campaign) {
            return response()->json([
                'status'  => false,
                'message' => 'Campaign not found.',
            ], 400);
        }

        // Fetch default currency
        $defaultCurrency = SiteSetup::first()->default_currency ?? '$';

        $goal = new Goals();
        $goal->start_date = $request->start_date;
        $goal->campaign_id = $request->campaign_id;
        $goal->end_date = $request->end_date;
        $goal->days = $request->days;
        $goal->price = $request->price;
        $goal->save();

        return response()->json([
            'status'  => true,
            'message' => 'Goal added successfully!',
            'goal'    => [
                'id'        => $goal->id,
                'start_date' => $goal->start_date,
                'end_date'  => $goal->end_date,
                'days'      => $goal->days,
                'price'     => $defaultCurrency . $goal->price, // Currency before price
            ],
            'campaign_details' => $campaign,
        ], 200);
    }

    // getCampaign
    public function getCampaign(Request $request)
    {
        $user = Auth::user();
        $vendor_id = $user->id;

        if (!empty($vendor_id)) {
            // Fetch campaigns related to the vendor
            $campaigns = Campaign::where('vendor_id', $vendor_id)->get();

            $isPayment = GoalPayment::where('vendor_id', $vendor_id)->first();



            if ($isPayment) {

                $is_expiary = $isPayment->end_date_do;

                $time = now();



                if ($is_expiary >= $time) {

                    $is_payment_status = "1";
                } else {

                    $is_payment_status = "0";
                }
            } else {

                $is_payment_status = "0"; // Explicitly set to "0" instead of null

            }

            if ($campaigns->isNotEmpty()) {
                foreach ($campaigns as $campaign) {
                    $campaign->campaign_name = $campaign->campaign_name ?? "";
                    $campaign->address = $campaign->address ?? "";
                    $campaign->lat = $campaign->lat ?? "";
                    $campaign->lon = $campaign->lon ?? "";
                    $campaign->area_distance = $campaign->area_distance ?? "";

                    // Fetch goals related to this campaign
                    $campaign->goals = DB::table('goals')
                        ->where('campaign_id', $campaign->id)
                        ->get();
                }

                return response()->json([
                    'status' => true,
                    'message' => 'Campaigns Found',
                    'campaignData' => $campaigns,
                    'is_payment_status' => $is_payment_status,
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'No campaigns found for this vendor',
                    'campaignData' => [],
                ]);
            }
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Please provide a vendor_id',
                'campaignData' => [],
            ]);
        }
    }

    // getGoals
    public function getGoals(Request $request)
    {
        $user = Auth::user();
        $user_id = $user->id;
        if (!empty($request->id)) {
            // Check if any campaigns exist for the given id
            $campaigns = Goals::where('id', $request->id)
                ->get();

            // If campaigns exist, process the data
            if ($campaigns->isNotEmpty()) {
                foreach ($campaigns as $campaign) {
                    $campaign->start_date = $campaign->start_date ?? "";
                    $campaign->end_date = $campaign->end_date ?? "";
                    $campaign->days = $campaign->days ?? "";
                    $campaign->price = $campaign->price ?? "";
                }

                return response()->json([
                    'status' => true,
                    'message' => 'Goals Found',
                    'GoalData' => $campaigns,
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'No Goals found ',
                    'GoalData' => [],
                ]);
            }
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Please provide a id',
                'GoalData' => [],
            ]);
        }
    }
    public function stripeIntent(Request $request)
    {
        $user = Auth::user();
        $myId = $user->id;
        // Get user_id from request
        // $myId = $request->input('user_id');
        // if (!$myId) {
        //     return $this->sendError("User ID Missing", "User ID is required", 400);
        // }

        // Get total amount from request
        $total = $request->input('total', 0);
        if ($total <= 0) {
            return $this->sendError("Invalid Amount", "Total amount must be greater than zero", 400);
        }

        // Fetch user email
        $user = \App\Models\User::find($myId);
        if (!$user) {
            return $this->sendError("User Not Found", "No user found with the given ID", 404);
        }

        $email = $user->email;
        $firstName = $user->first_name ?? 'Customer';
        $lastName = $user->last_name ?? '';

        \Stripe\ApiRequestor::setHttpClient(new \Stripe\HttpClient\CurlClient([CURLOPT_SSL_VERIFYPEER => false]));

        try {
            \Stripe\Stripe::setApiKey('sk_test_51OP303SJayPbST1lMDr6nn6WieehdLmIpiG2pgVil38DVNPjDqKcFG87d1GMOk10WWtoqZIxvSx2WLAP7G1GMkWu00SJWzq7cn');

            // Create Stripe client
            $stripe = new \Stripe\StripeClient('sk_test_51OP303SJayPbST1lMDr6nn6WieehdLmIpiG2pgVil38DVNPjDqKcFG87d1GMOk10WWtoqZIxvSx2WLAP7G1GMkWu00SJWzq7cn');

            // ✅ Create Stripe customer
            $customer = $stripe->customers->create([
                'email' => $email,
                'name' => $firstName . ' ' . $lastName,
            ]);

            // ✅ Create payment intent linked to that customer
            $res = $stripe->paymentIntents->create([
                'amount' => (int)$total * 100,
                'currency' => "usd",
                'description' => "Nylitical Subscription",
                'customer' => $customer->id,
                'receipt_email' => $email,
                'automatic_payment_methods' => ['enabled' => true],
                'shipping' => [
                    'name' => $firstName,
                    'address' => [
                        'line1' => "510 Townsend St",
                        'postal_code' => "98140",
                        'city' => "San Francisco",
                        'state' => "CA",
                        'country' => "US",
                    ],
                ],
            ]);

            return $this->sendresponse(['clientSecret' => $res->client_secret], 'Response');
        } catch (\Throwable $th) {
            return $this->sendError("Payment Error", $th->getMessage());
        }
    }

    // getGoalsPayment
    public function getGoalsPayment(Request $request)
    {
        $user = Auth::user();
        $vendor_id = $user->id;
        if (!empty($vendor_id)) {
            // Fetch goal_id from GoalPayment table using vendor_id
            $goalIds = GoalPaymentHistory::where('vendor_id', $vendor_id)
                ->pluck('goal_id');

            // Fetch goals data using goal_id
            $goals = Goals::whereIn('id', $goalIds)->get();

            if ($goals->isNotEmpty()) {
                foreach ($goals as $goal) {
                    $goal->start_date = $goal->start_date ?? "";
                    $goal->end_date = $goal->end_date ?? "";
                    $goal->days = $goal->days ?? "";
                    $goal->price = $goal->price ?? "";
                }

                return response()->json([
                    'status' => true,
                    'message' => 'Goals Found',
                    'GoalData' => $goals,
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'No Goals found',
                    'GoalData' => [],
                ]);
            }
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Please provide a vendor_id',
                'GoalData' => [],
            ]);
        }
    }




    // getSubscribePayment
    public function getSubscribePayment(Request $request)
    {
        $user = Auth::user();
        $user_id = $user->id;

        if (!empty($user_id)) {
            // $user_id = $request->user_id;

            // Fetch user subscription data based on user_id
            // $subscriptions = UserSubscription::where('user_id', $user_id)->get();
            $subscriptions = UserSubscriptionHistory::where('user_id', $user_id)->orderByDesc('id')->get();

            if ($subscriptions->isNotEmpty()) {
                foreach ($subscriptions as $subscription) {
                    $subscription->start_date = $subscription->start_date ?? "";
                    $subscription->expire_date = $subscription->expire_date ?? "";
                    $subscription->plan_name = $subscription->plan_name ?? "";
                    $subscription->price = $subscription->price ?? "";
                    $subscription->payment_mode = $subscription->payment_mode ?? "";
                }

                return response()->json([
                    'status' => true,
                    'message' => 'Payment subscription found',
                    'data' => $subscriptions,
                ]);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'No payment history found',
                    'data' => [],
                ]);
            }
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Please provide a valid user_id',
                'data' => [],
            ]);
        }
    }


    public function getallSubscribePayment(Request $request)
    {
        $user = Auth::user();
        $user_id = $user->id;
        // if (!empty($request->user_id)) {
        $service_id = $request->service_id;

        $vendor = Service::where('id', $service_id)->first();
        $user_id = $vendor->vendor_id;

        // Fetch user subscription data based on user_id
        $subscriptions = UserSubscriptionHistory::where('user_id', $user_id)->get();

        if ($subscriptions->isNotEmpty()) {
            foreach ($subscriptions as $subscription) {
                $subscription->start_date = $subscription->start_date ?? "";
                $subscription->expire_date = $subscription->expire_date ?? "";
                $subscription->plan_name = $subscription->plan_name ?? "";
                $subscription->price = $subscription->price ?? "";
                $subscription->payment_mode = $subscription->payment_mode ?? "";
                $subscription->status = $subscription->status ?? "";

                $time_stamp = now()->format('Y-m-d');

                $done = UserSubscriptionHistory::where($subscription->end_date_do, '>=', $time_stamp)->first();
                $subscription->all_status = $done ? "1" : "0";
            }

            return response()->json([
                'status' => true,
                'message' => 'Subcription List found',
                'data' => $subscriptions,
            ]);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'No Subcription history found',
                'data' => [],
            ]);
        }
    }
}
