import java.util.Properties
import java.io.FileInputStream
 
plugins {
    id("com.android.application")
    id("kotlin-android")
    // The Flutter Gradle Plugin must be applied after the Android and Kotlin Gradle plugins.
    id("dev.flutter.flutter-gradle-plugin")
    id("com.google.gms.google-services") version "4.3.15"
}
 
// Load keystore properties from key.properties file
val keystorePropertiesFile = rootProject.file("key.properties")
val keystoreProperties by lazy {
    Properties().apply {
        load(keystorePropertiesFile.inputStream())
    }
}
 
android {
    namespace = "com.primocys.nlytical"
    compileSdk = 35
    ndkVersion = "27.0.12077973"
 
    compileOptions {
        sourceCompatibility = JavaVersion.VERSION_17
        targetCompatibility = JavaVersion.VERSION_17
        isCoreLibraryDesugaringEnabled = true
    }
 
    kotlinOptions {
        jvmTarget = JavaVersion.VERSION_17.toString()
    }
 
    defaultConfig {
        // TODO: Specify your own unique Application ID (https://developer.android.com/studio/build/application-id.html).
        applicationId = "com.primocys.nlytical"
        // You can update the following values to match your application needs.
        // For more information, see: https://flutter.dev/to/review-gradle-config.
        minSdk = 24
        targetSdk = 34
        versionCode = flutter.versionCode
        versionName = flutter.versionName
        multiDexEnabled = true
    }
 
    buildTypes {
        release {
            // TODO: Add your own signing config for the release build.
            // Signing with the debug keys for now, so `flutter run --release` works.
            signingConfig = signingConfigs.getByName("debug")
        }
    }
 
    // Enable ViewBinding if needed by Stripe
    buildFeatures {
        viewBinding = true
    }
}
 
flutter {
    source = "../.."
}
 
dependencies {
    implementation(platform("com.google.firebase:firebase-bom:31.0.0"))
    implementation("com.google.android.gms:play-services-wallet:19.1.0")
    coreLibraryDesugaring("com.android.tools:desugar_jdk_libs:2.1.4")
 
    // Multidex
    implementation("androidx.multidex:multidex:2.0.1")
 
    // Stripe + Crypto dependencies
    implementation("com.stripe:stripe-android:20.40.0")
    implementation("com.google.crypto.tink:tink-android:1.12.0")
    implementation("com.nimbusds:nimbus-jose-jwt:9.37")
 
    // Razorpay
    implementation("com.razorpay:checkout:1.6.33")
}