// pages/ProtectedRoute.js
import { Navigate, Outlet } from "react-router-dom";
import { useAuth } from "../utils/AuthContext";

export default function ProtectedRoute() {
  const { authStatus } = useAuth();

  if (authStatus === "loading") return null;

  return authStatus === "valid" ? (
    <Outlet />
  ) : (
  <Navigate  />
  );
}
