import React from 'react'
import { useSelector } from 'react-redux';
import SearchBar from '../../Componets/SearchBar/SearchBar';
import { Link, useNavigate } from 'react-router-dom';
import ViewUserDetail from './ViewUserDetail';
import UserLIkeandcommentDetail from './UserLIkeandcommentDetail';
import ViewUSerTable from './ViewUSerTable';
import { MdArrowBack } from 'react-icons/md';

function ViewUser() {
  const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
  const navigate = useNavigate();


  return (
    <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
      <SearchBar />

      <div className="px-4 pb-10 xl:px-6">
        <div className="w-full flex justify-between items-center gap-2">
          {/* Left Content */}
          <div className="flex flex-col">
            {/* Header */}
            <div className="flex justify-between border-t-[#F2F2F2] py-3">
              <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">
                View User
              </h2>
            </div>

            {/* Breadcrumb */}
            <div className="mb-4 flex items-center gap-2">
              <Link to="/dashboard">
                <h3 className="text-base font-semibold text-[#3A3A3A] font-poppins">
                  Dashboard
                </h3>
              </Link>
              <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
              <h3 className="text-base text-[#858585] font-poppins">View User</h3>
            </div>
          </div>

          {/* Back Button */}
          <button
            onClick={() => navigate(-1)} // go back
            className="flex items-center gap-2 px-4 py-[6px] text-white cursor-pointer bggradient font-poppins rounded-md"
          >
            <MdArrowBack size={20} />
            Back
          </button>
        </div>
      </div>


      <div className=" mx-auto gap-y-6  w-[97%] rounded-lg flex  flex-col  xl:flex-row border border-bordercolor p-6">
        <div className=' w-full xl:w-[24%] flex flex-col  gap-4'>
          <ViewUserDetail />
          <UserLIkeandcommentDetail />
        </div>

        <div className='  w-full xl:w-[76%] '>
          <ViewUSerTable />

        </div>
      </div>

    </div>
  )
}

export default ViewUser
