import React, { useState } from 'react'
import { UseGetUserDetail } from '../../Appstore/Api/UseGetUserDetail';
import AvatarWithSpinner from '../../Componets/LoadingComponest';
import LIkeViewuset from './LIkeViewuset';
import ReviewUserView from './ReviewUserView';

function ViewUSerTable() {
    const [option, setOption] = useState("LIkeViewuset");
    const { data, isLoading } = UseGetUserDetail()


    return (
        <div className=' w-full '>
            <div className=" mx-auto  w-[97%] rounded-lg  border border-bordercolor p-2 md:p-6">
                <div className="mt-5 border rounded-lg  border-bordercolor md:mt-0">
                    <div className=" flex ">
                        {/* Like List */}
                        <button
                            className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "LIkeViewuset" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                            onClick={() => setOption("LIkeViewuset")}
                        >
                            Like List
                        </button>

                        {/* Review List*/}
                        <button
                            className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3 rounded-tl-lg text-sm ${option === "ReviewUserView" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
                            onClick={() => setOption("ReviewUserView")}
                        >
                            Review List
                        </button>


                    </div>


                    {isLoading ? (
                        <div className="p-4 h-full flex justify-center items-center">
                            <AvatarWithSpinner />
                        </div>
                    ) : (
                        <>
                            {option === "LIkeViewuset" && <LIkeViewuset />}
                            {option === "ReviewUserView" && <ReviewUserView/>}
                           
                        </>
                    )}

                </div>
            </div>
        </div>
    )
}

export default ViewUSerTable
