import React from 'react';
import icon from "../../assets/Images/vendorview.png";
import icon2 from "../../assets/Images/vendor12.png";
import { UseGetUserDetail } from '../../Appstore/Api/UseGetUserDetail';

function UserLikeAndCommentDetail() {
    const { data, isLoading } = UseGetUserDetail();

    return (
        <div className="w-full flex flex-col md:flex-row justify-between gap-4 h-auto md:h-[10rem]">
            {/* Likes Box */}
            <div className="flex w-full items-center justify-between border border-[#FF4B4B26] rounded-lg px-6 py-4 shadow-md relative  bg-primary">
                <div className="flex flex-col items-center justify-center gap-2 pl-5">
                    <div className="bg-[#FF4B4B12] p-3 rounded-full">
                        <img src={icon} alt="Like Icon" className="w-8 h-8" />
                    </div>
                    <div className="text-center">
                        <h3 className="font-bold text-lg text-vendorcolor font-poppins">
                            {data?.total_likes ?? 0}
                        </h3>
                        <p className="text-sm text-[#FF4B4B] font-medium font-poppins">Total Likes</p>
                    </div>
                </div>
                <div className="absolute top-2 right-0 bg-[#FF4B4B] px-1 h-12   rounded-l-lg text-white text-xs flex items-center">
                    {/* Optional Tag */}
                </div>
            </div>

            {/* Comments Box */}
            <div className="flex w-full items-center justify-between border border-[#27AF4D26] rounded-lg px-6 py-4 shadow-md relative bg-primary">
                <div className="flex flex-col items-center justify-center gap-2">
                    <div className="bg-[#27AF4D12] p-3 rounded-full">
                        <img src={icon2} alt="Comment Icon" className="w-8 h-8" />
                    </div>
                    <div className="text-center">
                        <h3 className="font-bold text-lg text-vendorcolor font-poppins">
                            {data?.total_reviews ?? 0}
                        </h3>
                        <p className="text-sm text-[#27AF4D] font-poppins  font-medium  ">Store Reviewed</p>
                    </div>
                </div>
                <div className="absolute top-2 right-0 bg-[#27AF4D] px-1 h-12   rounded-l-lg text-white text-xs flex items-center">
                    {/* Optional Tag */}
                </div>
            </div>
        </div>
    );
}

export default UserLikeAndCommentDetail;
