import { useSelector } from 'react-redux';
import { useLocation, useNavigate } from 'react-router-dom';
import SearchBar from '../../Componets/SearchBar/SearchBar';
import viewse from "../../assets/Images/invoisce.png";
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader';
import SimpletextTableBody from '../../Componets/TableComponets/SimpletextTableBody';
import useApiPost from '../../Hooks/PostData';
import { useEffect } from 'react';
import TableDateTimeDisplay from '../../Componets/TableComponets/TableDateTimeDisplay';
import { PDFDownloadLink } from '@react-pdf/renderer';
import InvoiceDocument from './InvoiceDocument';

function ViewSubscribedVendor() {
  const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
  const navigate = useNavigate();
  const location = useLocation();

  const currentPath = location.pathname.split("/");
  const sourcePage = currentPath[1] || "user-list";

  const { postData, data } = useApiPost();
  const id = sessionStorage.getItem("vendoridsubs");

  useEffect(() => {
    if (!id) return;
    const payload = new FormData();
    payload.append("id", id);
    postData("/view-subscriber", payload);
  }, [id]);


    const vendorName = data?.category?.vendor_name || 'invoice';


    const currnecy  = sessionStorage.getItem("defaultCurrency") || "USD";

  return (
    <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
      <SearchBar />

      <div className="flex justify-between  flex-col  md:flex-row gap-y-4 items-center border-t-[#F2F2F2] py-3 px-6">
        <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">Overview Subscription Information</h2>

        {/* Download Invoice Button */}
        {data?.category && (
          <PDFDownloadLink
            document={<InvoiceDocument data={data} />}
            fileName={`${vendorName.replace(/\s+/g, '_')}_invoice.pdf`}

            style={{
              textDecoration: 'none',
              padding: '10px 16px',
              background: 'linear-gradient(to right, #086ada, #0046AE)',
              color: '#fff',
              borderRadius: '8px',
              display: 'flex',
              alignItems: 'center',
              gap: '8px'
            }}
          >
            <img src={viewse} className="w-5 h-5 object-cover" alt="download" />
            <span className="text-white font-poppins text-sm">Download Invoice</span>
          </PDFDownloadLink>
        )}

      </div>

      {/* Breadcrumb */}
      <div className="flex items-center justify-between px-6">
        <div className="flex items-center gap-2">
          <h3 className="text-[#3A3A3A] font-poppins text-base font-semibold cursor-pointer" onClick={() => navigate("/dashboard")}>Dashboard</h3>
          <div className="rounded-full w-1 h-1 bg-[#808080]" />
          <button className="text-[#3A3A3A] font-poppins font-semibold text-base cursor-pointer" onClick={() => navigate(`/${sourcePage}`)}>
            {sourcePage.split("-").map(word => word.charAt(0).toUpperCase() + word.slice(1)).join(" ")}
          </button>
        </div>
      </div>

      <div className="mx-auto w-[97%] border border-bordercolor mt-12 rounded-lg p-4">
        {/* Vendor Info Section */}
        <div className='w-full flex justify-between items-center gap-4 flex-col md:flex-row'>
          <div className='flex flex-col gap-3'>
            <div className='flex font-medium text-lg font-poppins text-textcolor gap-2'>
              Subscription ID : <span className='text-[#9D9B9B]'>#{data?.category?.id}</span>
            </div>
            <div className='flex font-medium text-lg font-poppins text-textcolor gap-2'>
              Subscription Date : <span className='text-[#9D9B9B]'><TableDateTimeDisplay dateString={data?.category?.created_at} /></span>
            </div>
            <div className='flex gap-4'>
              <button className='px-4 py-1 rounded-lg bg-[#D4F1E0] text-[#28B765] font-poppins'>Paid</button>
              <button className='px-4 py-1 rounded-lg bg-[#D2DEF4] text-[#0046AE] font-poppins'>{data?.category?.payment_mode}</button>
            </div>
          </div>

          <div className='flex flex-col gap-3'>
            <h4 className='font-medium font-poppins text-lg text-[#0046AE]'>Vendor Details:</h4>
            <h5 className='text-lg text-textcolor font-poppins'>{data?.category?.vendor_name}</h5>
            <p className='text-lg font-poppins text-[#9D9B9B]'>{data?.category?.email}</p>
            <p className='text-lg font-poppins text-[#9D9B9B]'>{data?.category?.mobile}</p>
          </div>
        </div>

        {/* Summary Table */}
        <h3 className='font-poppins text-lg font-medium text-[#0046AE] mt-6'>Summary:</h3>
        <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
          <div className="min-w-[1200px]">
            <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
              <div className="w-[30%]"><WithoutSorttableHeader label="SUBSCRIPTION ID" /></div>
              <div className="w-[20%]"><WithoutSorttableHeader label="PLAN NAME" /></div>
              <div className="w-[15%]"><WithoutSorttableHeader label="PRICE" /></div>
              <div className="w-[15%]"><WithoutSorttableHeader label="START DATE" /></div>
              <div className="w-[15%]"><WithoutSorttableHeader label="EXPIRED DATE" /></div>
            </div>
          </div>

          <div className="relative">
            <div className="flex min-w-[1200px] items-center px-4 py-3 border-b border-bordercolor sm:pl-8 text-sm font-poppins gap-4 bg-primary">
              <div className="w-[30%]"><SimpletextTableBody title={`#${data?.category?.id || ""}`} /></div>
              <div className="w-[20%]"><SimpletextTableBody title={data?.category?.plan_name ?? ""} /></div>
              <div className="w-[15%]"><SimpletextTableBody title={`${currnecy} ${data?.category?.price ?? ""}`} /></div>
              <div className="w-[15%]"><SimpletextTableBody title={data?.category?.start_date ?? ""} /></div>
              <div className="w-[15%]"><SimpletextTableBody title={data?.category?.expire_date ?? ""} /></div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
}

export default ViewSubscribedVendor;
