import React, { useState } from "react";
import { useSelector } from "react-redux";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import { Link, useNavigate } from "react-router-dom";
import Overall from "./Overall/Overall";
import StoreViewVendor from "./StoreViewVendor/StoreViewVendor";
import ServiceViewVendor from "./ServiceViewVendor/ServiceViewVendor";
import ReviewsViewVendor from "./ReviewsViewVendor/ReviewsViewVendor";
import SubscriptionViewVendor from "./SubscriptionViewVendor/SubscriptionViewVendor";
import SponsorsViewVendor from "./SponsorsViewVendor/SponsorsViewVendor";
import { UseGetVendordetail } from "../../Appstore/Api/UseGetVendordetail";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import { MdArrowBack } from "react-icons/md";

function VendorView() {
  const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
  const [option, setOption] = useState("Overall");



  const { data, isLoading } = UseGetVendordetail()


  console.log("datavendor detail", data)
  const navigate = useNavigate();



  return (
    <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
      <SearchBar />

      {/* <div className="px-4 pb-10 xl:px-6">
        <div className="flex justify-between border-t-[#F2F2F2] py-3">
          <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3 ">View Vendor</h2>
        </div>

        <div className="mb-4 flex items-center gap-2">
          <Link to="/dashboard">
            <h3 className="text-base font-semibold text-[#3A3A3A]  font-poppins">Dashboard</h3>
          </Link>
          <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
          <h3 className="text-base text-[#858585] font-poppins"> View Vendor</h3>
        </div>
      </div> */}

      <div className="px-4 pb-10 xl:px-6">
        <div className="w-full flex justify-between items-center gap-2">
          {/* Left Content */}
          <div className="flex flex-col">
            {/* Header */}
            <div className="flex justify-between border-t-[#F2F2F2] py-3">
              <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">
                View Vendor
              </h2>
            </div>

            {/* Breadcrumb */}
            <div className="mb-4 flex items-center gap-2">
              <Link to="/dashboard">
                <h3 className="text-base font-semibold text-[#3A3A3A] font-poppins">
                  Dashboard
                </h3>
              </Link>
              <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
              <h3 className="text-base text-[#858585] font-poppins">View Vendor</h3>
            </div>
          </div>

          {/* Back Button */}
          <button
            onClick={() => navigate(-1)} // go back
            className="flex items-center gap-2 px-4 py-[6px] text-white cursor-pointer bggradient font-poppins rounded-md"
          >
            <MdArrowBack size={20} />
            Back
          </button>
        </div>
      </div>




      <div className=" mx-auto  w-[97%] rounded-lg  border border-bordercolor p-6">
        <div className="mt-5 border rounded-lg  border-bordercolor md:mt-0">
          <div className=" flex flex-col xl:flex-row ">
            {/* Overall */}
            <button
              className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "Overall" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
              onClick={() => setOption("Overall")}
            >
              Overall
            </button>

            {/* Store*/}
            <button
              className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3 rounded-tl-lg text-sm ${option === "StoreViewVendor" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
              onClick={() => setOption("StoreViewVendor")}
            >
              Store
            </button>

            {/* Service*/}
            <button
              className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3 rounded-tl-lg text-sm ${option === "ServiceViewVendor" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
              onClick={() => setOption("ServiceViewVendor")}
            >
              Service
            </button>

            {/* Reviews*/}
            <button
              className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3 rounded-tl-lg text-sm ${option === "ReviewsViewVendor" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
              onClick={() => setOption("ReviewsViewVendor")}
            >
              Reviews
            </button>


            {/* Subscription*/}
            <button
              className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3 rounded-tl-lg text-sm ${option === "SubscriptionViewVendor" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
              onClick={() => setOption("SubscriptionViewVendor")}
            >
              Subscription
            </button>

            <button
              className={`font-poppins font-semibold border-b  border-bordercolor cursor-pointer w-full py-3  rounded-r-lg text-sm ${option === "SponsorsViewVendor" ? "text-[#FFFFFF] bggradient" : " text-[#5B5B5B]"}`}
              onClick={() => setOption("SponsorsViewVendor")}
            >
              Sponsors
            </button>
          </div>


          {isLoading ? (
            <div className="p-4 h-full flex justify-center items-center">
              <AvatarWithSpinner />
            </div>
          ) : (
            <>
              {option === "Overall" && <Overall />}
              {option === "StoreViewVendor" && <StoreViewVendor />}
              {option === "ServiceViewVendor" && <ServiceViewVendor />}
              {option === "ReviewsViewVendor" && <ReviewsViewVendor />}
              {option === "SubscriptionViewVendor" && <SubscriptionViewVendor />}
              {option === "SponsorsViewVendor" && <SponsorsViewVendor />}
            </>
          )}

        </div>
      </div>

    </div>
  );
}

export default VendorView;
