import React from 'react';
import WithoutSorttableHeader from '../../../Componets/TableComponets/WithoutSorttableHeader';
import { UseGetVendordetail } from '../../../Appstore/Api/UseGetVendordetail';
import notfound from "../../../assets/Images/notfound.png";
import AvatarWithSpinner from '../../../Componets/LoadingComponest';
import SimpletextTableBody from '../../../Componets/TableComponets/SimpletextTableBody';
import TableDateTimeDisplay from '../../../Componets/TableComponets/TableDateTimeDisplay';

function SubscriptionViewVendor() {
  const { data, isLoading } = UseGetVendordetail();

  return (
    <div className="w-[97%] p-5">
      {/* Table Header */}
      <div className="flex items-center px-4 py-4 rounded-lg text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
        <div className="w-[8%]"><WithoutSorttableHeader label="S.L" /></div>
        <div className="w-[20%]"><WithoutSorttableHeader label="PLAN NAME" /></div>
        <div className="w-[12%]"><WithoutSorttableHeader label="PRICE" /></div>
        <div className="w-[13%]"><WithoutSorttableHeader label="START DATE" /></div>
        <div className="w-[13%]"><WithoutSorttableHeader label="EXPIRED DATE" /></div>
        <div className="w-[20%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
        <div className="w-[14%]"><WithoutSorttableHeader label="PAYMENT MODE" /></div>
      </div>

      {/* Table Body */}
      <div className="relative">
        {isLoading ? (
          <div className="h-[400px] flex items-center justify-center">
            <AvatarWithSpinner />
          </div>
        ) : data?.subscriptions?.length > 0 ? (
          data.subscriptions.map((gift: any, index: number) => (
            <div
              key={gift.id}
              className={`flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 text-sm font-poppins gap-4 ${index % 2 === 0
                ? "bg-white dark:bg-primary"
                : "bg-[#00162e0a] dark:bg-primary"
                }`}
            >
              {/* S.L */}
              <div className="w-[8%]">{index + 1}</div>

              {/* PLAN NAME */}
              <div className="w-[20%]">
                <SimpletextTableBody title={gift.plan_name} />
              </div>

              {/* PRICE */}
              <div className="w-[12%]">
                <SimpletextTableBody title={`$${gift.price}`} />
              </div>

              {/* START DATE */}
              <div className="w-[13%]">
                <SimpletextTableBody title={gift.start_date} />
              </div>

              {/* EXPIRED DATE */}
              <div className="w-[13%]">
                <SimpletextTableBody title={gift.expire_date} />
              </div>

              {/* CREATED DATE/TIME */}
              <div className="w-[20%]">
                <TableDateTimeDisplay dateString={gift.created_at} />
              </div>

              {/* PAYMENT MODE */}
              <div className="w-[14%]">
                <div
                  className={`w-fit rounded-xl px-3 py-1 font-medium ${gift?.payment_mode === "user"
                    ? "bg-[#D4F1E0] text-[#4CAF50]"
                    : gift?.payment_mode === "vendor"
                      ? "bg-[#D2DFF5] text-[#0046AE]"
                      : gift?.payment_mode === "stripe"
                        ? "bg-[#E0F7FA] text-[#00ACC1]"
                        : gift?.payment_mode === "flutterwave"
                          ? "bg-[#FFF3E0] text-[#FB8C00]"
                          : gift?.payment_mode === "razorpay"
                            ? "bg-[#F3E5F5] text-[#8E24AA]"
                            : "bg-gray-200 text-gray-600"
                    }`}
                >
                  {{
                    user: "Customer",
                    vendor: "Vendor",
                    stripe: "Stripe",
                    flutterwave: "Flutterwave",
                    razorpay: "Razorpay",
                  }[gift?.payment_mode] || "Unknown"}
                </div>
              </div>
            </div>
          ))
        ) : (
          <div className="p-4 h-[38rem] flex justify-center items-center">
            <div className="w-full flex flex-col items-center h-full justify-center">
              <img
                src={notfound}
                alt="Not Found"
                className="w-1/2 max-h-[40vh] object-contain"
              />
              <h2 className="font-poppins text-lg text-textcolor mt-4">
                No Subscription Found
              </h2>
            </div>
          </div>
        )}
      </div>
    </div>
  );
}

export default SubscriptionViewVendor;
