import React from "react";
import WithoutSorttableHeader from "../../../Componets/TableComponets/WithoutSorttableHeader";
import { UseGetVendordetail } from "../../../Appstore/Api/UseGetVendordetail";
import AvatarWithSpinner from "../../../Componets/LoadingComponest";
import notfound from "../../../assets/Images/notfound.png";
import SimpletextTableBody from "../../../Componets/TableComponets/SimpletextTableBody";
import TableDateTimeDisplay from "../../../Componets/TableComponets/TableDateTimeDisplay";
import EditIcon from "../../../assets/Images/edit.png";
import { useNavigate } from "react-router-dom";
import toast from "react-hot-toast";

function ServiceViewVendor() {
  const { data, isLoading } = UseGetVendordetail();
  const navigate = useNavigate();


      const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const handalupdate = (id: string) => {

     if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
    sessionStorage.setItem("updateserviceid", id);
    navigate(`/service-list/update-service`);
  };

  return (
    <div className="w-full px-4 md:px-6 py-5">
      {/* Table Header - Hidden on mobile */}
      <div className="flex items-center px-4 py-4 text-left rounded-lg border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
        <div className="w-[5%]">
          <WithoutSorttableHeader label="S.L" />
        </div>
        <div className="w-[30%]">
          <WithoutSorttableHeader label="SERVICE" />
        </div>
        <div className="w-[30%]">
          <WithoutSorttableHeader label="STORE" />
        </div>
        <div className="w-[10%]">
          <WithoutSorttableHeader label="PRICE" />
        </div>
        <div className="w-[15%]">
          <WithoutSorttableHeader label="CREATED DATE/TIME" />
        </div>
        <div className="w-[10%]">
          <WithoutSorttableHeader label="ACTIONS" />
        </div>
      </div>

      <div className="relative">
        {isLoading ? (
          <div className="h-[400px] flex items-center justify-center">
            <AvatarWithSpinner />
          </div>
        ) : data?.stores?.length > 0 ? (
          data.stores.map((gift: any, index: number) => (
            <div
              key={gift.id}
              className={`${
                index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"
              } flex flex-col sm:flex-row gap-4 sm:gap-0 items-start sm:items-center px-4 py-3 border-b border-b-bordercolor`}
            >
              <div className="w-full sm:w-[5%] text-sm text-textcolor font-poppins">
                {index + 1}
              </div>

              <div className="w-full sm:w-[30%] flex gap-3 items-start sm:items-center">
                <div className="w-10 h-10 rounded-full overflow-hidden flex-shrink-0">
                  <img
                    src={gift?.store_images?.[0]?.url || notfound}
                    alt="Service"
                    className="w-full h-full object-cover"
                  />
                </div>
                <div className="flex flex-col">
                  <h4 className="text-[#0046AE] text-sm font-poppins line-clamp-1">
                    {gift.store_name}
                  </h4>
                  <p className="text-[#a4a9b4] font-poppins text-sm">
                    Price: {gift.price}
                  </p>
                </div>
              </div>

              <div className="w-full sm:w-[30%] text-sm">
                <SimpletextTableBody title={gift?.service?.service_name} />
              </div>

              <div className="w-full sm:w-[10%] text-sm">
                <SimpletextTableBody title={gift.price} />
              </div>

              <div className="w-full sm:w-[15%] text-sm">
                <TableDateTimeDisplay dateString={gift.created_at} />
              </div>

              <div className="w-full sm:w-[10%] pl-1 sm:pl-5">
                <button
                  className="py-[10px] px-[10px] bg-[#D0CCE1]/60 rounded-full cursor-pointer"
                  onClick={() => handalupdate(gift.id)}
                >
                  <img src={EditIcon} alt="Edit" className="w-4 h-4" />
                </button>
              </div>
            </div>
          ))
        ) : (
          <div className="p-4 h-[38rem] flex justify-center items-center">
            <div className="w-full flex flex-col items-center justify-center">
              <img
                src={notfound}
                alt="Not Found"
                className="w-1/2 max-h-[40vh] object-contain"
              />
              <h2 className="font-poppins text-lg text-textcolor mt-4">
                No Service Found
              </h2>
            </div>
          </div>
        )}
      </div>
    </div>
  );
}

export default ServiceViewVendor;
