import { UseGetVendordetail } from '../../../Appstore/Api/UseGetVendordetail';
import notfound  from   "../../../assets/Images/notfound.png"

function ServicelistViewVendior() {
    const { data, isLoading } = UseGetVendordetail()


    console.log("my service store name ", data?.stores)


    return (
        <div className='w-full flex flex-col gap-4  h-[24rem]  overflow-y-auto'>
            {/* Service Item */}
            {data?.stores.length > 0 ? (
                data?.stores.map((user: any, index: number) => (
                    <div
                        key={index} // Add a unique key for each item in the map
                        className='w-full flex   items-center border-b border-b-bordercolor p-3'
                    >
                        {/* Service Number */}
                        <p className='font-poppins w-[20%] font-normal text-sm    pl-2 text-black'>{index + 1}</p> {/* Display index + 1 as the number */}

                        {/* Service Details (Image and Text) */}
                        <div className='flex items-center gap-4 w-full'>
                            {/* Avatar */}
                            <div className='w-14 h-14 rounded-full cursor-pointer'>
                                <img
                                    src={user.store_images[0]?.url}
                                    alt="Service Avatar"
                                    className='w-full h-full rounded-full object-cover'
                                />
                            </div>

                            {/* Service Name and Price */}
                            <div className='flex flex-col justify-between'>
                                <h2 className='font-poppins font-medium text-black text-lg'>{user?.store_name}</h2> {/* Use user data for name */}
                                <p className='font-poppins font-normal text-sm text-[#939393]'>Price: ${user?.price || "1000"}</p> {/* Use user data for price */}
                            </div>
                        </div>

                        {/* Service Cost */}

                        <div className=' w-fit items-center'>
                            <p className='font-poppins  w-full px-4  items-center  font-medium text-black text-lg'>${user?.price || "500"}</p> {/* Use user data for cost */}

                        </div>
                    </div>
                ))
            ) : (
                <div className="p-4 h-[38rem] flex justify-center items-center">
                    <div className="w-full flex flex-col items-center h-full justify-center">
                        <img
                            src={notfound}
                            alt="Not Found"
                            className="w-1/2 max-h-[30vh] object-contain"
                        />
                        <h2 className="font-poppins text-lg text-textcolor mt-4">
                            No Service Found
                        </h2>
                    </div>
                </div>
            )}


        </div>
    );
}

export default ServicelistViewVendior;
