import React, { useEffect, useState } from 'react';
import { useSelector, useDispatch } from 'react-redux';
import { Link, useLocation, useNavigate } from 'react-router-dom';

import SearchBar from '../../Componets/SearchBar/SearchBar';
import General1 from "../../assets/Images/download.png";
import General from "../../assets/Images/set1.png";
import UpdateBusinessInfo from './UpdateBusinessInfo/UpdateBusinessInfo';
import UpdateContactDetails from './UpdateContactDetails/UpdateContactDetails';
import UpdateBusinessYearTitle from './UpdateBusinessYearTitle/UpdateBusinessYearTitle';
import UpdateMedia from './UpdateMedia/UpdateMedia';
import UpdateMetaData from './UpdateMetaData/UpdateMetaData';
import useApiPost from '../../Hooks/PostData';
import { updateStoreValues } from '../../Appstore/Slice/StoreUpdate/serviceSlice';
import { useAppSelector } from '../../Hooks/Hooks';
import addstore from "../../assets/Images/addstore1.png"
import addstore2 from "../../assets/Images/addstore12.png"
import addstore3 from "../../assets/Images/addstore3.png"
import addstore4 from "../../assets/Images/addstore4.png"
import addstore5 from "../../assets/Images/addstore5.png"
import adddark from "../../assets/Images/adddark.png"
import adddark2 from "../../assets/Images/adddark2.png"
import adddark3 from "../../assets/Images/adddark3.png"
import adddark4 from "../../assets/Images/adddark4.png"
import adddark5 from "../../assets/Images/adddark5.png"
import { MdArrowBack } from 'react-icons/md';

const options = [
  {
    key: "UpdateBusinessInfo",
    label: "Business Info",
    iconLight: addstore,
    iconDark: adddark,
    component: <UpdateBusinessInfo />,
  },
  {
    key: "UpdateContactDetails",
    label: "Contact Details",
    iconLight: addstore2,
    iconDark: adddark2,
    component: <UpdateContactDetails />,
  },
  {
    key: "UpdateBusinessYearTitle",
    label: "Business Time & Year Title",
    iconLight: addstore3,
    iconDark: adddark3,
    component: <UpdateBusinessYearTitle />,
  },
  {
    key: "UpdateMedia",
    label: "Media",
    iconLight: addstore4,
    iconDark: adddark4,
    component: <UpdateMedia />,
  },
  {
    key: "UpdateMetaData",
    label: "Meta Data",
    iconLight: addstore5,
    iconDark: adddark5,
    component: <UpdateMetaData />,
  },
];

interface ServiceUpdateResponse {
  status: boolean;
  message: string;
  service: any;
  service_images: { id: number; service_images: string }[];
  cover_image: string;
  video_thumbnail: string;
  video: string;
}


function UpdateStore() {
  const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
  const navigate = useNavigate();
  const location = useLocation();
  const dispatch = useDispatch();

  const currentPath = location.pathname.split('/');
  const sourcePage = currentPath[1] || 'user-list';

  const [currentStepIndex, setCurrentStepIndex] = useState(0);

  const currentStepKey = options[currentStepIndex]?.key;
  const selectedComponent = options[currentStepIndex]?.component;

  const handleStepChange = (index: number) => {
    setCurrentStepIndex(index);
  };



  const storeID = sessionStorage.getItem("storID")


  const { loading, postData, data } = useApiPost()


  console.log("update service values!!!!!!!!!", data)

  useEffect(() => {
    if (storeID) {
      const formdata = new FormData();
      formdata.append("service_id", storeID);
      postData("/edit-service", formdata);
    }
  }, [storeID]);

  useEffect(() => {
    if (data?.status && data?.service) {
      const response = data as ServiceUpdateResponse;
      dispatch(
        updateStoreValues({
          service: response.service,
          service_images: response.service_images,
          cover_image: response.cover_image,
          video_thumbnail: response.video_thumbnail,
          video: response.video,
        })
      );
    }
  }, [data, dispatch]); // <-- Add `data` here




  const service = useAppSelector((state) => state.service)

  console.log("  my update service values", service)



  return (
    <div className={`bg-primary min-h-screen ${isSidebarOpen ? 'xl:pl-20' : 'xl:pl-72'}`}>
      <SearchBar />

      <div className="px-4  xl:px-6">
        <div className="w-full flex justify-between items-center gap-2">
          {/* Left Content */}
          <div className="flex flex-col">
            {/* Header */}
            <div className="flex justify-between border-t-[#F2F2F2] py-3">
              <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">
                Update Store
              </h2>
            </div>

            {/* Breadcrumb */}
            <div className="mb-4 flex items-center gap-2">
              <Link to="/dashboard">
                <h3 className="text-base font-semibold text-[#3A3A3A] font-poppins">
                  Dashboard
                </h3>
              </Link>
              <div className="h-1 w-1 rounded-full bg-[#E0E0E0]"></div>
              <h3 className="text-base text-[#858585] font-poppins">Update Store</h3>
            </div>
          </div>

          {/* Back Button */}
          <button
            onClick={() => navigate(-1)} // go back
            className="flex items-center gap-2 px-4 py-[6px] text-white cursor-pointer bggradient font-poppins rounded-md"
          >
            <MdArrowBack size={20} />
            Back
          </button>
        </div>
      </div>

      {/* Main Form */}
      <div className="mx-auto w-[97%] border border-bordercolor mt-12 rounded-lg p-4">
        <div className="md:flex  flex-col">
          {/* Sidebar Options */}
          <div className="flex  gap-4 md:flex-row   flex-col">
            {options.map(({ key, label, iconLight, iconDark }, index) => (
              <button
                key={key}
                onClick={() => handleStepChange(index)}
                className={`flex items-center gap-2 px-4 py-3.5 rounded-xl cursor-pointer lg:w-[300px] md:w-[220px]  ${currentStepKey === key ? "bggradient" : "border border-bordercolor"
                  }`}
              >
                <img
                  src={currentStepKey === key ? iconDark : iconLight}
                  className="w-5 h-5"
                  alt="icon"
                />
                <p className={`font-poppins text-sm font-normal ${currentStepKey === key ? "text-[#FFFFFF]" : "text-textcolor"}`}>
                  {label}
                </p>
              </button>
            ))}
          </div>

          {/* Component Display */}
          <div className="w-full mt-4">{selectedComponent}</div>
        </div>
      </div>
    </div>
  );
}

export default UpdateStore;
