import React, { useEffect, useRef, useState } from 'react';
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import { updateServiceField } from '../../../Appstore/Slice/StoreUpdate/serviceSlice';

function UpdateMetaDescriptionNew() {
    const editorRef = useRef<HTMLDivElement>(null);
    const quillInstance = useRef<any>(null);
    const [isQuillReady, setIsQuillReady] = useState(false);

    const dispatch = useAppDispatch();
    const service_description = useAppSelector(
        (state) => state.service.service?.meta_description || ""
    );



    console.log("service_descriptionservice_descriptionservice_description", service_description)

    // Load Quill CSS
    useEffect(() => {
        const quillCSS = document.createElement('link');
        quillCSS.rel = 'stylesheet';
        quillCSS.href = 'https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.snow.css';
        document.head.appendChild(quillCSS);
    }, []);

    // Load Quill JS dynamically
    useEffect(() => {
        const script = document.createElement('script');
        script.src = 'https://cdn.jsdelivr.net/npm/quill@2.0.3/dist/quill.js';
        script.onload = () => setIsQuillReady(true);
        document.body.appendChild(script);
    }, []);

    // Initialize Quill once
    useEffect(() => {
        if (isQuillReady && window.Quill && editorRef.current && !quillInstance.current) {
            quillInstance.current = new window.Quill(editorRef.current, {
                theme: 'snow',
                placeholder: 'Write your meta description here...',
            });

            // Add text change handler
            quillInstance.current.on('text-change', () => {
                const html = editorRef.current?.querySelector('.ql-editor')?.innerHTML || '';
                // dispatch(StoreaddDescriptionState({ service_description: html }));
                dispatch(updateServiceField({ key: "meta_description", value: html }));
            });

            // Set initial content
            if (service_description) {
                quillInstance.current.clipboard.dangerouslyPasteHTML(service_description);
            }
        }
    }, [isQuillReady]);

    // Sync Redux value into Quill when updated externally
    useEffect(() => {
        const currentHtml = quillInstance.current?.root.innerHTML;
        if (
            quillInstance.current &&
            service_description &&
            currentHtml !== service_description
        ) {
            quillInstance.current.clipboard.dangerouslyPasteHTML(service_description);
        }
    }, [service_description]);

    return (
        <div className="font-poppins overflow-hidden">
            <label
                htmlFor="businessDescription"
                className="block text-sm font-normal mb-2  text-textcolor"
            >
                Meta Description<span className="text-[#FF0000]"> *</span>
            </label>
            <div
                ref={editorRef}
            />
        </div>

    );
}

export default UpdateMetaDescriptionNew;
