import React from 'react'
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import FormGlobalInputAnalytical from '../../../Componets/Form/FormGlobalINputNlytical';
import { updateServiceField } from '../../../Appstore/Slice/StoreUpdate/serviceSlice';
import MetaDescriptionUpdate from './MetaDescriptionUpdate';
import useApiPost from '../../../Hooks/PostData';
import toast from 'react-hot-toast';
import UpdateMetaDescriptionNew from './UpdateMetaDescriptionNew';

function UpdateMetaData() {


  const { loading, data, postData } = useApiPost()

  const formData = useAppSelector((state) => state.service.service);


  const dispatch = useAppDispatch()

  const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    const { name, value } = e.target;
    dispatch(updateServiceField({ key: name as keyof typeof formData, value }));
  };


  const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const service_id = sessionStorage.getItem("storID")

  const handalsubmit = async () => {

    if (IS_DEMO) {
      toast.error("This action is disabled in the demo version.");
      return;
    }
    const payload = new FormData();

    payload.append("service_id", service_id || "");
    payload.append("meta_title", formData?.meta_title || "")
    payload.append("meta_description", formData?.meta_description || "")
    try {
      const response = await postData("/edit-service", payload, "multipart/form-data");
      console.log("Update successful:", response);
      toast.success("Update successful")

    } catch (err) {
      console.error("Update failed:", err);
    }
  };

  return (
    <div className="w-full flex flex-col p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid gap-4">
        <FormGlobalInputAnalytical
          label="Meta Title"
          name="meta_title"
          value={formData.meta_title || ""}
          onChange={handleChange}
          required
          placeholder="Enter Meta Title"
        />

        {/* <MetaDescriptionUpdate /> */}
        <UpdateMetaDescriptionNew />
      </div>
      <div className="w-full flex justify-center items-center">
        <button
          className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white"
          onClick={handalsubmit}
          disabled={loading}
        >
          {loading ? "Updating..." : "Update"}
        </button>
      </div>
    </div>
  )
}

export default UpdateMetaData
