import React, { useRef, useState, useEffect } from "react";
import crossicon from "../../../assets/Images/cross.png";
import uploadicon from "../../../assets/Images/upload.png";
import toast from "react-hot-toast";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { removeCoverImageByIndex, updateAddserviceImages } from "../../../Appstore/Slice/UploadAddserviceImageSlice";
import useApiPost from "../../../Hooks/PostData";
import Apimethod from "../../../Hooks/Apimethod";
import { reset, setTrue } from "../../../Appstore/Slice/toggleSlice";
import { updateStoreValues } from "../../../Appstore/Slice/StoreUpdate/serviceSlice";

interface ServiceUpdateResponse {
    status: boolean;
    message: string;
    service: any;
    service_images: { id: number; service_images: string }[];
    cover_image: string;
    video_thumbnail: string;
    video: string;
}


function StoreImageUpdate() {

    const updatestoreimage = useAppSelector((state) => state.service.service_images)

    const updatedetail = useAppSelector((state) => state.service)

    const dispatch = useAppDispatch()

    console.log(" my service image update ", updatestoreimage)

    const coverImages = useAppSelector((state) => state.UploadAddserviceImageSlice.cover_images);


    const fileInputRef = useRef<HTMLInputElement>(null);
    const [previewImages, setPreviewImages] = useState<string[]>([]);

    useEffect(() => {
        const urls = coverImages.map((file) => URL.createObjectURL(file));
        setPreviewImages(urls);

        return () => {
            urls.forEach((url) => URL.revokeObjectURL(url));
        };
    }, [coverImages]);

    const handleFileClick = () => {
        fileInputRef.current?.click();
    };

    const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
        const files = e.target.files;
        if (!files || files.length === 0) return;

        const validImages = Array.from(files).filter((file) =>
            file.type.startsWith("image/")
        );

        if (validImages.length !== files.length) {
            toast.error("Only image files are allowed.");
            return;
        }

        dispatch(updateAddserviceImages(validImages));
    };


    const storeID = sessionStorage.getItem("storID") || ""


    const { makeRequest } = Apimethod()

    const { loading, postData, data } = useApiPost()




    const handleRemoveFile = async (index: number) => {
        console.log("postDatamonu", index)
        dispatch(reset())
        const payload = new FormData()
        payload.append("vendor_id", updatedetail.service?.vendor_id || "")
        payload.append("service_id", storeID)
        payload.append("service_image_id", index.toString())
        let res = await makeRequest("/remove-serviceimages", payload, "multipart/form-data", "POST");


        console.log("resresresres", res)
        if (res?.success == true) {
            dispatch(setTrue())
        }
    };


    //  is api call

    const isapicall = useAppSelector((state) => state.toggle.value)


    useEffect(() => {
        if (isapicall) {
            const payload = new FormData()
            payload.append("service_id", storeID)
            postData("/edit-service", payload)
        }

    }, [isapicall])

    useEffect(() => {
        if (data?.status && data?.service) {
            const response = data as ServiceUpdateResponse;
            dispatch(
                updateStoreValues({
                    service: response.service,
                    service_images: response.service_images,
                    cover_image: response.cover_image,
                    video_thumbnail: response.video_thumbnail,
                    video: response.video,
                })
            );
        }
    }, [data, dispatch]); // <-- Add `data` here

    const handleRemoveFileLocal = (index: number) => {
        dispatch(removeCoverImageByIndex(index));
    };

    return (
        <div className="overflow-hidden h-fit">
            <div>
                <label className="font-poppins text-sm font-medium text-textcolor">
                    Store Images  <span className=" text-[#808080]  text-[13px]  font-poppins">(Multiple images can be uploaded)</span>
                    <span className="text-[#F21818] pl-[1px]">*</span>
                </label>

                <div
                    className="font-poppins mt-2 flex h-[2.8rem] w-full border border-bordercolor cursor-pointer items-center justify-center rounded-lg p-3 borderinputbox"
                    onClick={handleFileClick}
                >
                    <input
                        type="file"
                        accept="image/*"
                        multiple
                        ref={fileInputRef}
                        onChange={handleFileChange}
                        className="hidden"
                    />
                    <div className="flex w-full gap-3 items-center justify-center">
                        <img src={uploadicon} alt="upload icon" className="h-4 w-4 object-cover" />
                        <p className="font-poppins text-[#B4B4B4] font-medium text-sm text-center">
                            Drop your images here or click to browse
                        </p>
                    </div>
                </div>
                <div className="mt-4 grid grid-cols-3 gap-4">
                    {/* API Values */}
                    {updatestoreimage.length > 0 && (
                        <div className=" flex col-span-4   flex-wrap gap-4">
                            {updatestoreimage.map((img, index) => (
                                <div key={index} className="relative flex items-center justify-center">
                                    <div className="relative">
                                        <img
                                            src={img.service_images}
                                            alt={`Uploaded preview ${index}`}
                                            className="uploadimageborder rounded-md object-cover w-[80px] h-[80px]"
                                        />
                                        <button
                                            type="button"
                                            className="absolute right-[-0.2rem] top-0"
                                            onClick={() => handleRemoveFile(img.id)}
                                        >
                                            <div className="flex h-6 w-6 items-center justify-center rounded-full bg-[#BABABA]">
                                                <img
                                                    src={crossicon}
                                                    alt="cross icon"
                                                    className="h-4 w-4 object-cover"
                                                />
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            ))}
                        </div>
                    )}

                    {/* Preview Images */}
                    {previewImages.length > 0 && (
                        <div className="col-span-3 flex flex-wrap gap-4">
                            {previewImages.map((img, index) => (
                                <div key={index} className="relative flex items-center justify-center">
                                    <div className="relative">
                                        <img
                                            src={img}
                                            alt={`Uploaded preview ${index}`}
                                            className="uploadimageborder rounded-md object-cover w-[80px] h-[80px]"
                                        />
                                        <button
                                            type="button"
                                            className="absolute right-[-0.2rem] top-0"
                                            onClick={() => handleRemoveFileLocal(index)}
                                        >
                                            <div className="flex h-6 w-6 items-center justify-center rounded-full bg-[#BABABA]">
                                                <img
                                                    src={crossicon}
                                                    alt="cross icon"
                                                    className="h-4 w-4 object-cover"
                                                />
                                            </div>
                                        </button>
                                    </div>
                                </div>
                            ))}
                        </div>
                    )}
                </div>

            </div>
        </div>
    );
}

export default StoreImageUpdate;
