import React, { useState } from 'react'
import PhoneNumberUpdate from './PhoneNumberUpdate'
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import { updateServiceField } from '../../../Appstore/Slice/StoreUpdate/serviceSlice';
import FormGlobalInputAnalytical from '../../../Componets/Form/FormGlobalINputNlytical';
import useApiPost from '../../../Hooks/PostData';
import toast from 'react-hot-toast';

function UpdateContactDetails() {

  const formData = useAppSelector((state) => state.service.service) || {};
  const dispatch = useAppDispatch();
  const [updatedFields, setUpdatedFields] = useState<Record<string, any>>({});




  const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    const { name, value } = e.target;
    dispatch(updateServiceField({ key: name as keyof typeof formData, value }));

    // Track only modified fields
    setUpdatedFields((prev) => ({
      ...prev,
      [name]: value,
    }));
  };



  const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const { loading, postData } = useApiPost();
  const service_id = sessionStorage.getItem("storID")
  const handalsubmit = async () => {

    if (IS_DEMO) {
      toast.error("This action is disabled in the demo version.");
      return;
    }
    const payload = new FormData();

    payload.append("service_country_code", formData?.service_country_code || "")
    payload.append("service_phone", formData?.service_phone || "")
    payload.append("service_id", service_id || "");
    // Append only updated fields
    Object.entries(updatedFields).forEach(([key, value]) => {
      payload.append(key, value);
    });

    try {
      const response = await postData("/edit-service", payload, "multipart/form-data");
      console.log("Update successful:", response);
      toast.success("Update successful")
    } catch (err) {
      console.error("Update failed:", err);
    }
  };

  return (
    <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid md:grid-cols-2 gap-4">

        <PhoneNumberUpdate />
        <FormGlobalInputAnalytical
          label="Email"
          labeloptionalvalues="Ex: support@example.com"
          name="service_email"
          value={formData.service_email || ""}
          onChange={handleChange}
          required
          placeholder="Enter Email"
        />
        <FormGlobalInputAnalytical
          label="Website"
          labeloptionalvalues="Ex: https://www.example.com"
          name="service_website"
          value={formData.service_website || ""}
          onChange={handleChange}
          required
          placeholder="Enter Web Link"
        />
        <FormGlobalInputAnalytical
          label="Facebook"
          labeloptionalvalues="Ex: https://www.example.com"
          name="facebook_link"
          value={formData.facebook_link || ""}
          onChange={handleChange}
          required
          placeholder="Enter Facebook Link"
        />
        <FormGlobalInputAnalytical
          label="WhatsApp"
          labeloptionalvalues="Ex: https://wa.me/1234567890"
          name="whatsapp_link"
          value={formData.whatsapp_link || ""}
          onChange={handleChange}
          required
          placeholder="Enter WhatsApp Link"
        />
        <FormGlobalInputAnalytical
          label="Instagram"
          labeloptionalvalues="Ex: https://www.instagram.com/example"
          name="instagram_link"
          value={formData.instagram_link || ""}
          onChange={handleChange}
          required
          placeholder="Enter Instagram Link"
        />
        <FormGlobalInputAnalytical
          label="Twitter"
          labeloptionalvalues="Ex: https://twitter.com/example"
          name="twitter_link"
          value={formData.twitter_link || ""}
          onChange={handleChange}
          required
          placeholder="Enter Twitter Link"
        />
      </div>

      <div className="w-full flex justify-center items-center">
        <button
          className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white"
          onClick={handalsubmit}
          disabled={loading}
        >
          {loading ? "Updating..." : "Update"}
        </button>
      </div>
    </div>
  )
}

export default UpdateContactDetails
