import React from "react";
import PhoneInput from "react-phone-input-2";
import "react-phone-input-2/lib/high-res.css";
import { useAppDispatch, useAppSelector } from "../../../Hooks/Hooks";
import { updateServiceField, updateStoreValues } from "../../../Appstore/Slice/StoreUpdate/serviceSlice";

function PhoneNumberUpdate() {
    const dispatch = useAppDispatch();

    const service = useAppSelector((state) => state.service.service);
    const service_country_code = service?.service_country_code;
    const service_phone = service?.service_phone;


    console.log(" my service number ", service_country_code, service_phone)

    const handlePhoneChange = (value: string, data: any) => {
        const countryCode = data.dialCode;
        const nationalNumber = value.replace(countryCode, "");
        dispatch(updateServiceField({ key: "service_country_code", value: `+${countryCode}` }));
        dispatch(updateServiceField({ key: "service_phone", value: nationalNumber }));
        console.log("Full:", value);
        console.log("Country Code:", `+${countryCode}`);
        console.log("National Number:", nationalNumber);
    };


    return (
        <div className="w-full flex flex-col gap-2">
            <label className="font-poppins text-sm font-medium text-[#000000]" htmlFor="mobile">
                Phone number
                <span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative w-full">
                <PhoneInput
                    country={"in"}
                    value={`${service_country_code?.replace("+", "")}${service_phone}`}
                    onChange={handlePhoneChange}
                    placeholder="Enter phone number"
                    enableSearch
                />
            </div>
        </div>
    );
}

export default PhoneNumberUpdate;
