import OpenDay from "../../AddStore/BusinessYearTitle/OpenDay";
import CloseDay from "../../AddStore/BusinessYearTitle/CloseDay";
import OpenTimeUpdate from "./OpenTimeUpdate";
import CloseTimeUpdate from "./CloseTimeUpdate";
import MonthDropdownUpdate from "./MonthDropdownUpdate";
import useApiPost from "../../../Hooks/PostData";
import toast from "react-hot-toast";
import { useAppSelector } from "../../../Hooks/Hooks";
import YearDropdownUpdate from "./YearDropdownUpdate";

function UpdateBusinessYearTitle() {
  const { loading, postData } = useApiPost();
  const service_id = sessionStorage.getItem("storID");
  const selectedDaysOpenDays = useAppSelector((state) => state.openDay.selectedDays);

  const serviceupdatevalues = useAppSelector((state) => state.service.service);


  const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  console.log(" my publish year@@", serviceupdatevalues?.published_year)

  const handalsubmit = async () => {


    if (IS_DEMO) {
      toast.error("This action is disabled in the demo version.");
      return;
    }
    const payload = new FormData();

    const dayMap: { [key: string]: string } = {
      Monday: "Mon",
      Tuesday: "Tue",
      Wednesday: "Wed",
      Thursday: "Thu",
      Friday: "Fri",
      Saturday: "Sat",
      Sunday: "Sun",
    };
    const allDays = Object.keys(dayMap);

    const openDaysStr = selectedDaysOpenDays.map((day) => dayMap[day]).join(", ");
    const closeDaysStr = allDays
      .filter((day) => !selectedDaysOpenDays.includes(day))
      .map((day) => dayMap[day])
      .join(", ");
    payload.append("open_days", openDaysStr);
    payload.append("closed_days", closeDaysStr);
    payload.append("open_time", serviceupdatevalues?.open_time || "");
    payload.append("close_time", serviceupdatevalues?.close_time || "");
    payload.append("published_month", serviceupdatevalues?.published_month || "");
    payload.append("published_year", serviceupdatevalues?.published_year || "");
    payload.append("service_id", service_id || "");

    try {
      const response = await postData("/edit-service", payload, "multipart/form-data");
      console.log("Update successful:", response);
      toast.success("Update successful");
    } catch (err) {
      console.error("Update failed:", err);
    }
  };

  return (
    <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid md:grid-cols-2 gap-4">
        <OpenDay />
        <CloseDay />
        <OpenTimeUpdate />
        <CloseTimeUpdate />
      </div>

      <div className=" w-full   flex flex-col  gap-4">
        <h4 className=" font-poppins   font-medium text-lg  text-[#0046AE] "> Year of Establishment</h4>
        <div className=" w-full   grid  grid-cols-2 gap-4">
          <MonthDropdownUpdate />
          <YearDropdownUpdate />
        </div>
      </div>

      <div className="w-full flex justify-center items-center">
        <button className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white" onClick={handalsubmit} disabled={loading}>
          {loading ? "Updating..." : "Update"}
        </button>
      </div>
    </div>
  );
}

export default UpdateBusinessYearTitle;
