import React, { useState } from 'react';
import { useAppDispatch, useAppSelector } from '../../../Hooks/Hooks';
import FormGlobalInputAnalytical from '../../../Componets/Form/FormGlobalINputNlytical';
import { updateServiceField } from '../../../Appstore/Slice/StoreUpdate/serviceSlice';
import VendordropdwonUpdate from './VendordropdwonUpdate';
import CategorylistInputUpdate from './CategorylistInputUpdate';
import SubCategoryDropdwonUpdate from './SubCategoryDropdwonUpdate';
import GoogleMapLocationUpdate from './GoogleMapLocationUpdate';
import StoreDescriptionUpdate from './StoreDescriptionUpdate';
import TotalMemberUpdate from './TotalMemberUpdate';
import useApiPost from '../../../Hooks/PostData';
import toast from 'react-hot-toast';
import UpdateStoreDescription from './UpdateStoreDescription';

function UpdateBusinessInfo() {
  const formData = useAppSelector((state) => state.service.service);
  const dispatch = useAppDispatch();
  const { loading, postData } = useApiPost();

  const [updatedFields, setUpdatedFields] = useState<Record<string, any>>({});

  const handleChange = (e: React.ChangeEvent<HTMLInputElement>) => {
    const { name, value } = e.target;
    dispatch(updateServiceField({ key: name as keyof typeof formData, value }));

    // Track only modified fields
    setUpdatedFields((prev) => ({
      ...prev,
      [name]: value,
    }));
  };

  const storedDescription = useAppSelector(
    (state) => state.service.service?.service_description || ""
  );


  const selectedSubCategories = useAppSelector((state) => state.subcategory.selectedSubCategories);

  const vendor_id = useAppSelector((state) => state.vendor.selectedVendor?.id);
  const selectedCategory = useAppSelector((state) => state.category.selectedCategory?.id);


  const location = useAppSelector((state) => state.location)

  console.log(" my location vlues fromrhg search engine", location)

  console.log("selectedVendormonunnn", vendor_id?.id)

  const service_id = sessionStorage.getItem("storID")
  const selectedValue = useAppSelector((state) => state.service.service?.employee_strength);



  const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


  const service = useAppSelector((state) => state.service.service)
  const handalsubmit = async () => {
    if (IS_DEMO) {
      toast.error("This action is disabled in the demo version.");
      return;
    }



    const payload = new FormData();

    payload.append("service_id", service_id || "");
    payload.append("service_description", storedDescription);
    payload.append("vendor_id", vendor_id ? String(vendor_id) : "");
    const latValue = location.lat || service?.lat;
    const lonValue = location.lng || service?.lon;

    if (latValue) {
      payload.append("lat", latValue.toString());
    }
    if (lonValue) {
      payload.append("lon", lonValue.toString());
    }
    payload.append("employee_strength", selectedValue || "");

    // Conditionally append category_id
    if (selectedCategory) {
      payload.append("category_id", String(selectedCategory));
    }

    // Conditionally append subcategory_id
    if (Array.isArray(selectedSubCategories) && selectedSubCategories.length > 0) {
      const subcategoryIds = selectedSubCategories.map((item) => item.id).join(",");
      payload.append("subcategory_id", subcategoryIds);
    }

    // Append only updated fields
    Object.entries(updatedFields).forEach(([key, value]) => {
      payload.append(key, value);
    });

    try {
      const response = await postData("/edit-service", payload, "multipart/form-data");
      console.log("Update successful:", response);
      toast.success("Update successful")
    } catch (err) {
      console.error("Update failed:", err);
    }
  };


  return (
    <div className="w-full flex flex-col mt-4 md:mt-0 p-6 border border-bordercolor rounded-lg gap-6">
      <div className="w-full h-fit grid md:grid-cols-2 gap-4">
        <FormGlobalInputAnalytical
          label="Store Name"
          name="service_name"
          value={formData?.service_name ?? ""}
          onChange={handleChange}
          required
          placeholder="Enter Store Name"
        />
        <VendordropdwonUpdate />
        <CategorylistInputUpdate />
        <SubCategoryDropdwonUpdate />
        {/* <StoreDescriptionUpdate />
         */}
        <UpdateStoreDescription />
        <GoogleMapLocationUpdate />
        {/* <FormGlobalInputAnalytical label="Store Location" name="service_address" value={formData?.service_address || ""} onChange={handleChange} required placeholder="Enter Store Location" /> */}
        <FormGlobalInputAnalytical label="Address (House No, Building, Street)" name="address" value={formData?.address || ""} onChange={handleChange} required placeholder="Enter Full Address" />
        <FormGlobalInputAnalytical label="Area" name="area" value={formData?.area || ""} onChange={handleChange} required placeholder="Enter Area" />
        <FormGlobalInputAnalytical label="City" name="city" value={formData?.city || ""} onChange={handleChange} required placeholder="Enter City" />
        <FormGlobalInputAnalytical label="State" name="state" value={formData?.state || ""} onChange={handleChange} required placeholder="Enter State" />
        <TotalMemberUpdate />
      </div>

      <div className="w-full flex justify-center items-center">
        <button
          className="w-fit px-[3rem] py-2 bggradient rounded-lg cursor-pointer font-poppins text-white"
          onClick={handalsubmit}
          disabled={loading}
        >
          {loading ? "Updating..." : "Update"}
        </button>
      </div>
    </div>
  );
}

export default UpdateBusinessInfo;
