"use client";
import { useDispatch } from "react-redux";
import { useEffect, useState } from "react";
import { MdOutlineCheck, MdOutlineChevronRight } from "react-icons/md";
import { useAppSelector } from "../../../Hooks/Hooks";
import {
    setSubCategoryList,
    toggleSubCategorySelection,
    resetSubCategoryState,
    removeSubCategory,
} from "../../../Appstore/Slice/SubCategorySlice";
import { UseGetSubcategory } from "../../../Appstore/Api/UseGetSubcategory";

interface CategoryDropdownProps {
    required?: boolean;
}

const SubCategoryDropdwonUpdate: React.FC<CategoryDropdownProps> = () => {
    const dispatch = useDispatch();

    const subcategory_id = useAppSelector((state) => state.service.service?.subcategory_id); // e.g., "17,18,26,28"
    const category_id = useAppSelector((state) => state.category.selectedCategory?.id);
  

    console.log("category_idcategory_idcategory_id subcategory_id" ,subcategory_id)


   

    const selectedSubCategories = useAppSelector((state) => state.subcategory.selectedSubCategories);
    const subCategories = useAppSelector((state) => state.subcategory.subCategories);


    console.log(" monu selected subcategory values" , selectedSubCategories)

    const [searchValue, setSearchValue] = useState<string>("");
    const [showDropdown, setShowDropdown] = useState<boolean>(false);
    const [rotate, setRotate] = useState<boolean>(false);

    const { data, isLoading, isSuccess, isError } = UseGetSubcategory(category_id);

    // Reset subcategories on category change
    useEffect(() => {
        dispatch(resetSubCategoryState());
        setSearchValue("");
    }, [category_id]);

    // Set subcategory list from API
    useEffect(() => {
        if (isSuccess) {
            const subList = data?.subCategoryData ?? [];
            dispatch(setSubCategoryList(subList));
        }
    }, [data, isSuccess]);

    // Auto-select subcategories from `subcategory_id` in service
   useEffect(() => {
    if (!subcategory_id || subCategories.length === 0) return;

    const selectedIds = subcategory_id
        .split(",")
        .map(id => parseInt(id.trim(), 10))
        .filter(id => !isNaN(id));

    // Prevent duplicate selection
    selectedIds.forEach(id => {
        const sub = subCategories.find(s => s.id === id);
        if (sub && !selectedSubCategories.some(s => s.id === id)) {
            dispatch(toggleSubCategorySelection(sub));
        }
    });
}, [subcategory_id, subCategories, dispatch, selectedSubCategories]);


    const handleToggleSelection = (subcategory: any) => {
        dispatch(toggleSubCategorySelection(subcategory));
        setSearchValue("");
    };

    const handleFocus = () => {
        if (category_id) {
            setShowDropdown(true);
            setRotate(true);
        }
    };

    const handleBlur = () => {
        setTimeout(() => {
            setShowDropdown(false);
            setRotate(false);
        }, 100);
    };

    const handleToggle = () => {
        if (category_id) {
            setShowDropdown((prev) => !prev);
            setRotate((prev) => !prev);
        }
    };

    const filteredSubcategories = subCategories.filter((item) =>
        item.subcategory_name.toLowerCase().includes(searchValue.toLowerCase())
    );

    const isSelected = (id: number) =>
        selectedSubCategories.find((sc) => sc.id === id) !== undefined;

    return (
        <div className="w-full flex flex-col relative h-full">
            <label htmlFor="subcategory" className="font-poppins text-sm font-normal text-textcolor">
                Sub Category<span className="text-[#F21818] pl-[1px]">*</span>
            </label>

            <div className="relative mt-1 flex items-center cursor-pointer">
                <input
                    type="text"
                    id="subcategory"
                    autoComplete="off"
                    spellCheck="false"
                    className="w-full rounded-lg border border-bordercolor cursor-pointer focus:border-toggalbtcolorborder text-textcolor bg-primary px-4 py-2.5 my-1 placeholder:text-placeholdercolor placeholder:text-sm focus:outline-none"
                    placeholder={
                        category_id
                            ? "Search or select subcategories"
                            : "Please select a category first"
                    }
                    value={searchValue}
                    onFocus={handleFocus}
                    onBlur={handleBlur}
                    onChange={(e) => setSearchValue(e.target.value)}
                    disabled={!category_id}
                />
                <div
                    className={`absolute right-2 text-xl cursor-pointer transition-transform ${rotate ? "rotate-90" : "-rotate-90"}`}
                    onClick={handleToggle}
                >
                    <MdOutlineChevronRight />
                </div>
            </div>

            {selectedSubCategories.length > 0 && (
                <div className="flex flex-wrap mt-2 gap-2">
                    {selectedSubCategories.map((subcategory) => (
                        <span
                            key={subcategory.id}
                            className="flex items-center bg-[#1c5bb9c4] text-white px-3 py-1 rounded-full text-sm font-poppins"
                        >
                            {subcategory.subcategory_name}
                            <button
                                className="ml-2 text-red-500 hover:text-red-700"
                                onClick={() => dispatch(removeSubCategory(subcategory.id))}
                            >
                                ×
                            </button>
                        </span>
                    ))}
                </div>
            )}

            {showDropdown && (
                <ul className="absolute top-[5rem] left-0 w-full bg-primary text-textcolor rounded-lg shadow-lg max-h-[200px] overflow-y-auto z-10 border border-bordercolor mt-1">
                    {isLoading ? (
                        <li className="px-4 py-2 font-poppins text-center text-gray-500">Loading...</li>
                    ) : isError ? (
                        <li className="px-4 py-2 font-poppins text-center text-red-500">
                            Failed to load subcategories
                        </li>
                    ) : filteredSubcategories.length > 0 ? (
                        filteredSubcategories.map((item) => (
                            <li
                                key={item.id}
                                className="px-4 py-2 cursor-pointer font-poppins hover:bg-gray-200 text-textcolor flex justify-between items-center"
                                onMouseDown={() => handleToggleSelection(item)}
                            >
                                {item.subcategory_name}
                                {isSelected(item.id) && (
                                    <MdOutlineCheck className="text-[#6565657a] text-lg" />
                                )}
                            </li>
                        ))
                    ) : (
                        <li className="px-4 py-2 font-poppins text-center text-gray-500">No subcategories found</li>
                    )}
                </ul>
            )}
        </div>
    );
};

export default SubCategoryDropdwonUpdate;
