import React, { useState, useRef, useMemo, useEffect } from "react";
import { useDispatch } from "react-redux";
import JoditEditor from "jodit-react";
import { useAppSelector } from "../../../Hooks/Hooks";
import { updateServiceField } from "../../../Appstore/Slice/StoreUpdate/serviceSlice";

const StoreDescriptionUpdate = () => {
  const dispatch = useDispatch();
  const editor = useRef(null);

  const storedDescription = useAppSelector(
    (state) => state.service.service?.service_description || ""
  );

   console.log("storedDescriptionstoredDescriptionstoredDescription" , storedDescription)


  const [content, setContent] = useState<string>(storedDescription);

  useEffect(() => {
    // Set initial description when loaded from redux
    setContent(storedDescription);
  }, [storedDescription]);

  const config = useMemo(
    () => ({
      readonly: false,
      placeholder: "Store description typing..." || "Store description typing...",
      toolbar: true,
      buttons: [
        "bold",
        "italic",
        "underline",
        "strike",
        "|",
        "font",
        "fontsize",
        "forecolor",
        "backcolor",
        "|",
        "ul",
        "ol",
        "outdent",
        "indent",
        "|",
        "align",
        "alignleft",
        "aligncenter",
        "alignright",
        "alignjustify",
        "|",
        "link",
        "image",
        "table",
        "video",
        "|",
        "undo",
        "redo",
        "removeformat",
        "clear",
        "|",
        "fullsize",
      ],
      spellcheck: true,
      showCharsCounter: false,
      showWordsCounter: false,
      height: 400,
      askBeforePasteHTML: false,
      cleanHTML: {
        removeStyles: true,
        removeTags: ["style", "script"],
      },
    }),
    []
  );

  const handleContentChange = (newContent: string) => {
    setContent(newContent);
    dispatch(updateServiceField({ key: "service_description", value: newContent }));
  };

  return (
    <div className="w-full overflow-hidden">
      <label
        className="block text-sm font-normal font-poppins text-[#000000]"
        htmlFor="businessDescription"
      >
        Store Description<span className="text-[#FF0000]"> *</span>
      </label>
      <div className="mt-2">
        <JoditEditor
          ref={editor}
          value={content}
          config={config}
          tabIndex={1}
          onBlur={(newContent) => handleContentChange(newContent)}
          onChange={(newContent) => handleContentChange(newContent)}
        />
      </div>
    </div>
  );
};

export default StoreDescriptionUpdate;
