import { useSelector } from "react-redux";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import { Link, useLocation, useNavigate } from "react-router-dom";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import Search from "../../assets/Images/search.png";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { useEffect, useState } from "react";
import notfound from "../../assets/Images/notfound.png";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import TableUserInfo from "../../Componets/TableComponets/TableUserInfo";
import SimpletextTableBody from "../../Componets/TableComponets/SimpletextTableBody";
import TableActionButtons from "../../Componets/TableComponets/TableActionButtons";
import Eye from "../../assets/Images/eye.png";
import { setSubscribedVendorPaginationSlice } from "../../Appstore/Slice/PaginationSlice/SubscribedVendorPaginationSlice";
import SubscribedVendorPagination from "../../Componets/PaginationComponets/SubscribedVendorPagination";
import { setSelectedVendor } from "../../Appstore/Slice/subscribedVendorSlice";



interface Vendor {
  id: number;
  email: string;
  expire_date: string;
  image: string;
  payment_mode: string;
  plan_name: string;
  price: string;
  start_date: string;
  status: number;
  user_id: string;
  vendor_name: string;
  created_at: string;
}

function SubscribedVendor() {
  const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
  const { data, loading, error, postData } = useApiPost();
  const pagination = useAppSelector((state) => state.SubscribedVendorPaginationSlice);
  const { current_page, records_per_page } = pagination;
  const [search, setSearch] = useState("");

  const dispatch = useAppDispatch();

  // Fetch data
  useEffect(() => {
    const params = {
      page: current_page,
      pageSize: records_per_page,
      search: search.trim(),
    };

    postData("/subscribed-users", params);
  }, [current_page, records_per_page, search]);

  useEffect(() => {
    if (data?.Pagination) {
      dispatch(setSubscribedVendorPaginationSlice(data?.Pagination));
    }
  }, [data, dispatch]);


  //  hanadal view funtion to vendor view 

  const navigate = useNavigate();
  const location = useLocation();

  const handleView = (vendor: Vendor) => {
    console.log('Selected Vendor:', vendor);
    dispatch(setSelectedVendor(vendor));
    const currentPath = location.pathname.split('/')[1];
    navigate(`/${currentPath}/view-subscribed-vendor`);
    sessionStorage.setItem("vendoridsubs", vendor.id !== undefined && vendor.id !== null ? String(vendor.id) : "")
  };



  const defaultCurrency = sessionStorage.getItem("defaultCurrency")





  return (
    <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
      <SearchBar />
      <div className="px-4 pb-10 xl:px-6">
        <div className="flex justify-between border-t-[#F2F2F2] py-3">
          <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3"> Subscribed Vendor List</h2>
          <div className="relative">
            <div className="absolute left-2  top-5 md:top-1/2 flex transform -translate-y-1/2 items-center p-2">
              <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
            </div>
            <div className=" w-full">
              <input
                type="text"
                placeholder="Search by name ,email..."
                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "
                onChange={(e) => setSearch(e.target.value)}
                value={search}
              />
            </div>
          </div>
        </div>

        <div className="flex items-center justify-between">
          <div className="flex items-center gap-2">
            <Link to="/dashboard">
              <h3 className="text-[#3A3A3A] font-poppins text-base font-semibold">Dashboard</h3>
            </Link>
            <div className="rounded-full w-1 h-1 bg-[#E0E0E0]" />
            <h3 className="text-[#858585] font-poppins text-base">Subscribed Vendor List</h3>
          </div>


        </div>

        <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
          <div className=" min-w-[1600px] xl:min-w-[1200px]">
            {/* Table Header */}
            <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
              <div className="w-[5%]"> <WithoutSorttableHeader label="S.L" /> </div>
              <div className="w-[20%]"> <WithoutSorttableHeader label="SUBSCRIBED VENDOR" /> </div>
              <div className="w-[15%]"> <WithoutSorttableHeader label="PLAN NAME" /> </div>
              <div className="w-[10%]"> <WithoutSorttableHeader label="PRICE" /> </div>
              <div className="w-[12%]"> <WithoutSorttableHeader label="START DATE" /> </div>
              <div className="w-[12%]"> <WithoutSorttableHeader label="EXPIRED DATE" /> </div>
              <div className="w-[8%]"> <WithoutSorttableHeader label="PAYMENT MODE" /> </div>
              <div className="w-[8%]"> <WithoutSorttableHeader label="STATUS" /> </div>
              <div className="w-[10%]"> <WithoutSorttableHeader label="ACTION" /> </div>
            </div>
          </div>

          <div className="relative">
            {loading ? (
              <div className="h-[400px] flex items-center justify-center">
                <AvatarWithSpinner />
              </div>
            ) : data?.customers?.length > 0 ? (
              data.customers.map((gift: any, index: number) => (
                <div
                  key={gift.gift_id}
                  className={`flex items-center min-w-[1600px] xl:min-w-[1200px] px-4 py-3 border-b border-bordercolor sm:pl-8 text-sm font-poppins gap-4 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"
                    }`}
                >
                  <div className="w-[5%]">{(current_page - 1) * records_per_page + index + 1}</div>

                  <div className="w-[20%]">
                    <TableUserInfo
                      profilePic={gift.image}
                      username={gift.vendor_name}
                      email={gift.email || "N/A"}
                      mobile={gift.country_code ? `${gift.country_code} ${gift.mobile || ""}` : "N/A"}
                      onClick={() => handleView(gift)}
                    />
                  </div>

                  <div className="w-[15%]">
                    <SimpletextTableBody title={gift.plan_name} />
                  </div>

                  <div className="w-[10%]">
                    <SimpletextTableBody title={` ${defaultCurrency}${gift.price}`} />
                  </div>

                  <div className="w-[12%]">
                    <SimpletextTableBody title={gift.start_date} />
                  </div>

                  <div className="w-[12%]">
                    <SimpletextTableBody title={gift.expire_date} />
                  </div>

                  <div className="w-[8%]">
                    {(() => {
                      const normalizedMode = gift?.payment_mode?.toLowerCase().replace(/\s+/g, "");

                      const modeStyles = {
                        user: "bg-[#D4F1E0] text-[#4CAF50]",
                        vendor: "bg-[#D2DFF5] text-[#0046AE]",
                        stripe: "bg-[#E0F7FA] text-[#00ACC1]",
                        flutterwave: "bg-[#FFF3E0] text-[#FB8C00]",
                        razorpay: "bg-[#F3E5F5] text-[#8E24AA]",
                        paypal: "bg-[#E0E7FF] text-[#003087]",
                        applepay: "bg-[#F0F0F0] text-[#000000]",
                        googlepay: "bg-[#FBE9E7] text-[#DB4437]",
                      };

                      const modeLabels = {
                        user: "Customer",
                        vendor: "Vendor",
                        stripe: "Stripe",
                        flutterwave: "Flutterwave",
                        razorpay: "Razorpay",
                        paypal: "PayPal",
                        applepay: "Apple Pay",
                        googlepay: "Google Pay",
                      };

                      return (
                        <div
                          className={`w-fit rounded-xl px-3 py-1 font-medium ${modeStyles[normalizedMode] || "bg-gray-200 text-gray-600"
                            }`}
                        >
                          {modeLabels[normalizedMode] || "Unknown"}
                        </div>
                      );
                    })()}
                  </div>



                  <div className="w-[8%]">
                    <div
                      className={`w-fit rounded-xl px-3 py-1 font-normal ${gift?.status === "1"
                        ? "bg-green-100 text-green-600"
                        : "bg-red-100 text-red-600"
                        }`}
                    >
                      {gift?.status === "1" ? "Active" : "Expired"}
                    </div>
                  </div>

                  <div className="w-[10%] relative">
                    <div className=" absolute  left-2.5  top-[-1rem]">
                      <TableActionButtons
                        viewButtonIcon={Eye}
                        onViewClick={() => handleView(gift)}
                        viewButtonColor="#CCE1CD"
                        borderColor="#01D312"
                      />
                    </div>
                  </div>
                </div>
              ))
            ) : (
              <div className="p-4 h-[38rem] flex justify-center items-center">
                <div className="w-full flex flex-col items-center h-full justify-center">
                  <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                  <h2 className="font-poppins text-lg text-textcolor mt-4">No  Data Found</h2>
                </div>
              </div>
            )}
          </div>

          <SubscribedVendorPagination />
        </div>

      </div>
    </div>
  );
}
export default SubscribedVendor;
