import { useEffect, useState } from 'react'
import { useSelector } from 'react-redux';
import { Link } from 'react-router-dom';
import Add from "../../assets/Images/add.png"
import SearchBar from '../../Componets/SearchBar/SearchBar';
import WithoutSorttableHeader from '../../Componets/TableComponets/WithoutSorttableHeader';
import useApiPost from '../../Hooks/PostData';
import notfound from "../../assets/Images/notfound.png"
import { useAppDispatch, useAppSelector } from '../../Hooks/Hooks';
import SimpletextTableBody from '../../Componets/TableComponets/SimpletextTableBody';
import TableDateTimeDisplay from '../../Componets/TableComponets/TableDateTimeDisplay';
import { showModal } from '../../Appstore/Slice/ModalSlice';
import { reset } from '../../Appstore/Slice/toggleSlice';
import TableActionButtons from '../../Componets/TableComponets/TableActionButtons';
import Eye from "../../assets/Images/eye.png"
import AvatarWithSpinner from '../../Componets/LoadingComponest';
import Search from '../../assets/Images/search.png';
import HashtagPagination from '../../Componets/PaginationComponets/HashtagPagination';
import { setPaginationHastaglList } from '../../Appstore/Slice/PaginationSlice/HashtagPaginationSlice';
import Block from "../../assets/Images/deleteicon.png";
import EditIcon from "../../assets/Images/edit.png";
import { clearCoverImage } from '../../Appstore/Slice/AddImageSlice';
import { setSubCategoryUpdate } from '../../Appstore/Slice/SubCategoryUpdateSlice';
import { clearSelectedCategory } from '../../Appstore/Slice/CategorySelectedIDandValues';
import toast from 'react-hot-toast';

function SubCategoryList() {

  const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
  const { data, loading, error, postData } = useApiPost();
  const [search, setSearch] = useState("")






  const pagination = useAppSelector((state) => state.HashtagPaginationSlice);
  const { current_page, records_per_page } = pagination;


  const [toggleStates, setToggleStates] = useState<{ [key: number]: boolean }>({});

  // Fetch data
  useEffect(() => {
    const params = {
      page: current_page,
      pageSize: records_per_page,
      search: search.trim()
    };

    postData("/subcategory-list", params);
  }, [current_page, records_per_page, search]);



  const isaddgiftvalues = useAppSelector((state) => state.toggle.value)


  useEffect(() => {
    if (isaddgiftvalues) {
      postData("/subcategory-list", {});
    }

  }, [isaddgiftvalues])




  useEffect(() => {
    if (data?.data?.subcategories) {
      const toggles = data?.data?.subcategories.reduce((acc, gift) => {
        acc[gift.id] = gift.status;
        return acc;
      }, {} as { [key: number]: boolean });
      setToggleStates(toggles);
    }
  }, [data]);



  const dispatch = useAppDispatch()


  useEffect(() => {
    if (data?.Pagination) {
      dispatch(setPaginationHastaglList(data?.Pagination));
    }
  }, [data, dispatch]);













  const handleBlock = (id: string) => {

    dispatch(showModal("SubCategoryDeleteModal"))
    dispatch(reset())
    sessionStorage.setItem("deleteSubCtId", id)
  }


  const handalupdateSubcategory = (gift: any) => {


    dispatch(setSubCategoryUpdate({
      category: {
        id: gift.id,
        subcategory_name: gift.subcategory_name,
        subcategory_image: gift.subcategory_image,
        category_id: gift.category_id,
      }
    }));
    dispatch(showModal("UpdateSubCategoryModal"));
    dispatch(clearSelectedCategory())
    dispatch(reset())

  };


  const subct = useAppSelector((state) => state.SubCategoryUpdateSlice.category)




  return (
    <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
      <SearchBar />
      <div className="px-4 pb-10 xl:px-6">
        <div className="flex justify-between border-t-[#F2F2F2] py-3">
          <h2 className="text-textcolor font-poppins  text-sm md:text-xl font-semibold pt-3 "> Sub Category List </h2>
          <div className="relative">
            <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
              <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
            </div>
            <div className=' w-full'>
              <input
                type="text"
                placeholder="Search by Sub Category Name..."
                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "

                onChange={(e) => setSearch(e.target.value)}
                value={search}
              />
            </div>
          </div>
        </div>

        <div className="flex items-center flex-col md:flex-row gap-y-4 justify-between">
          <div className="flex items-center gap-2">
            <Link to="/dashboard">
              <h3 className="text-[#3A3A3A] font-poppins text-base  font-semibold">Dashboard</h3>
            </Link>
            <div className="rounded-full w-1 h-1 bg-[#E0E0E0]"></div>
            <h3 className="text-[#858585] font-poppins text-base">Sub Category  List</h3>
          </div>

          <button
            className="flex gap-1.5 mr-1 py-2 cursor-pointer place-items-center px-4 font-poppins font-medium text-white rounded-md bggradient"

            onClick={() => {

              dispatch(showModal("AddSubCategoryModal"))
              dispatch(reset())
              dispatch(clearCoverImage())
              dispatch(clearSelectedCategory())

            }}

          >
            <img src={Add} className="w-4 h-4" />
            <p className="md:text-sm text-xs">Add Sub Category</p>
          </button>
        </div>


        <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
          <div className="min-w-[1200px]">
            {/* Header Row */}
            <div className="flex items-center px-4 py-4 text-left border-b w-full bg-headercolortable border-b-bordercolor sm:pl-8 gap-4">
              <div className="w-[5%]"><WithoutSorttableHeader label="S.L" /></div>
              <div className="w-[30%]"><WithoutSorttableHeader label="SUB CATEGORY NAME" /></div>
              <div className="w-[15%]"><WithoutSorttableHeader label="PARENT CATEGORY" /></div>
              <div className="w-[20%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
              <div className="w-[20%]"><WithoutSorttableHeader label="TOTAL STORES" /></div>
              <div className="w-[10%]"><WithoutSorttableHeader label="ACTIONS" /></div>
            </div>

            {/* Table Body */}
            <div className="relative">
              {loading ? (
                <div className="h-[400px] flex items-center justify-center">
                  <AvatarWithSpinner />
                </div>
              ) : data?.data?.subcategories?.length > 0 ? (
                data.data.subcategories.map((gift: any, index: number) => (
                  <div
                    key={gift.gift_id}
                    className={`flex items-center px-4 py-4 border-b border-b-bordercolor sm:pl-8 gap-4 ${index % 2 === 0
                      ? 'bg-white dark:bg-primary'
                      : 'bg-[#00162e0a] dark:bg-primary'
                      }`}
                  >
                    <div className="w-[5%] text-sm text-textcolor font-poppins">
                      {(current_page - 1) * records_per_page + index + 1}
                    </div>

                    <div className="w-[30%]">
                      <div className="flex items-center gap-3">
                        <div className="w-[4rem] h-[3.2rem] flex justify-center items-center rounded-full">
                          <img
                            src={gift.subcategory_image}
                            className="w-full h-full object-cover rounded-full"
                            alt="Subcategory"
                          />
                        </div>
                        <SimpletextTableBody title={gift.subcategory_name} />
                      </div>
                    </div>

                    <div className="w-[15%]">
                      <SimpletextTableBody title={gift.category_name} />
                    </div>

                    <div className="w-[20%]">
                      <TableDateTimeDisplay dateString={gift.created_at} />
                    </div>

                    <div className="w-[20%] relative">
                      <div className=' absolute left-8'>
                        <SimpletextTableBody title={gift.total_services} />
                      </div>
                    </div>

                    <div className="w-[10%] relative flex items-center gap-3">
                      <div className=' w-full flex   absolute left-[-1rem] items-center  gap-3 '>
                        <button className=" py-[9px] px-[10px] cursor-pointer bg-[#D0CCE1]/60 rounded-full" onClick={() => handalupdateSubcategory(gift)}>
                          <img src={EditIcon} alt="Edit" className="w-5 h-4" />
                        </button>
                        <TableActionButtons
                          onBlockClick={() => handleBlock(gift.id)}
                          viewButtonColor="#CCE1CD"
                          blockButtonColor="#FDE4EA"
                          borderColor="#01D312"
                          blockButtonIcon={Block}
                        />
                      </div>
                    </div>
                  </div>
                ))
              ) : (
                <div className="p-4 h-[38rem] flex justify-center items-center">
                  <div className="w-full flex flex-col items-center h-full justify-center">
                    <img
                      src={notfound}
                      alt="Not Found"
                      className="w-1/2 max-h-[40vh] object-contain"
                    />
                    <h2 className="font-poppins text-lg text-textcolor mt-4">
                      No  Data Found
                    </h2>
                  </div>
                </div>
              )}
            </div>
          </div>

          {/* Pagination Component */}
          <HashtagPagination />
        </div>

      </div>

    </div>
  )
}

export default SubCategoryList
