import React, { useEffect } from 'react';
import WithoutSorttableHeader from '../../../../Componets/TableComponets/WithoutSorttableHeader';
import useApiPost from '../../../../Hooks/PostData';
import SimpletextTableBody from '../../../../Componets/TableComponets/SimpletextTableBody';
import notfound from "../../../../assets/Images/notfound.png";
import AvatarWithSpinner from '../../../../Componets/LoadingComponest';

function SubscriptionPayment() {
  const { data, postData, loading } = useApiPost();
  const storIDViews = sessionStorage.getItem("storIDViews");

  useEffect(() => {
    if (!storIDViews) return;
    const params = { service_id: storIDViews };
    postData("/get-allsusbcribepayment", params);
  }, [storIDViews]);

  const subscriptionData = data?.data || [];

  return (
    <div className="p-4">
      <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
        <div className="min-w-[1200px]">
          {/* Table Header */}
          <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
            <div className="w-[10%]"><WithoutSorttableHeader label="S.L" /></div>
            <div className="w-[15%]"><WithoutSorttableHeader label="PLAN NAME" /></div>
            <div className="w-[15%]"><WithoutSorttableHeader label="PRICE" /></div>
            <div className="w-[20%]"><WithoutSorttableHeader label="START DATE" /></div>
            <div className="w-[20%]"><WithoutSorttableHeader label="END DATE" /></div>
            <div className="w-[20%]"><WithoutSorttableHeader label="PAYMENT MODE" /></div>
          </div>

          {/* Table Body */}
          <div className="relative">
            {loading ? (
              <div className="h-[400px] flex items-center justify-center">
                <AvatarWithSpinner />
              </div>
            ) : subscriptionData.length > 0 ? (
              subscriptionData.map((item, index) => (
                <div
                  key={item.id}
                  className="flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 bg-white dark:bg-primary gap-4 text-sm font-poppins text-textcolor dark:text-gray-300"
                >
                  <div className="w-[10%]">{index + 1}</div>
                  <div className=' w-[15%]'>
                    <SimpletextTableBody title={`${item.plan_name || "0"}`} />
                  </div>
                  <div className=' w-[15%]'>
                    <SimpletextTableBody title={`${item.price || "0"}`} />
                  </div>
                  <div className=' w-[20%]'>
                    <SimpletextTableBody title={item.start_date || "N/A"} />
                  </div>

                  <div className=' w-[20%]'>
                    <SimpletextTableBody title={item.expire_date || "N/A"} />

                  </div>
                  <div className=' w-[20%]'>
                    <div
                      className={`w-fit rounded-xl px-3 py-1 font-medium ${item?.payment_mode === "user"
                        ? "bg-[#D4F1E0] text-[#4CAF50]"
                        : item?.payment_mode === "vendor"
                          ? "bg-[#D2DFF5] text-[#0046AE]"
                          : item?.payment_mode === "stripe"
                            ? "bg-[#E0F7FA] text-[#00ACC1]"
                            : item?.payment_mode === "flutterwave"
                              ? "bg-[#FFF3E0] text-[#FB8C00]"
                              : item?.payment_mode === "razorpay"
                                ? "bg-[#F3E5F5] text-[#8E24AA]"
                                : "bg-gray-200 text-gray-600"
                        }`}
                    >
                      {{
                        user: "Customer",
                        vendor: "Vendor",
                        stripe: "Stripe",
                        flutterwave: "Flutterwave",
                        razorpay: "Razorpay",
                      }[item?.payment_mode] || "Unknown"}
                    </div>
                  </div>
                </div>
              ))
            ) : (
              <div className="p-4 h-[38rem] flex justify-center items-center">
                <div className="w-full flex flex-col items-center h-full justify-center">
                  <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                  <h2 className="font-poppins text-lg text-textcolor mt-4">No Data Found</h2>
                </div>
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
  );
}

export default SubscriptionPayment;
