"use client";

import React from "react";
import { useAppSelector } from "../../../../Hooks/Hooks";
import verfiyicon from "../../../../assets/Images/verfiy.png";

function VenderDetailInformation() {
  // Get vendor and store details from Redux
  const service = useAppSelector((state) => state.adminStore.data?.service);
  const vendor = service?.vendor;
  const storeDetails = service?.stores;

  // Fallback values
  const fullName = `${vendor?.first_name || "John"} ${vendor?.last_name || "Doe"}`;
  const avatarUrl = vendor?.image || "/assets/placeholder-user.png";
  const totalStores = storeDetails?.total_service_count ?? 0;
  const publishedYear = storeDetails?.published_year || "2020";
  const publishedMonth = storeDetails?.published_month || "January";

  const handleListModal = () => {
    console.log("Open modal with service list");
  };

  return (
    <div className="p-4 rounded-lg border border-bordercolor">
      {/* Heading */}
      <h2 className="text-lg font-medium font-poppins mb-4  text-textcolor">
        Vendor Information
      </h2>

      {/* Vendor Info */}
      <div className="flex items-center gap-6">
        {/* Avatar */}
        <div
          className="h-12 w-12 rounded-full bg-cover bg-center"
          style={{ backgroundImage: `url(${avatarUrl})` }}
        />

        {/* Vendor Name & Info */}
        <div className="flex flex-col">
          <div className="flex items-center gap-2 text-lg font-medium font-poppins  text-textcolor">
            <span>{fullName}</span>
            <img className="h-5 w-5" src={verfiyicon} alt="Verified Icon" />
          </div>

          <div className="text-sm mt-1 flex items-center text-[#757575] gap-2">
            <span
              className="text-[#0046AE] font-poppins cursor-pointer"
              onClick={handleListModal}
            >
              {totalStores} Services
            </span>

            <span className="ml-2 flex items-center gap-2 font-poppins  text-textcolor">
              <span className="h-1 w-1 bg-[#0046AE] rounded-full"></span>
              Member since {publishedYear} {publishedMonth}
            </span>
          </div>
        </div>
      </div>
    </div>
  );
}

export default VenderDetailInformation;
