import "./style.css";
import { useAppSelector } from '../../../../Hooks/Hooks';

function VenderDetail() {
    const vendordetail = useAppSelector((state) => state.adminStore.data?.service.vendor);

    return (
        <div className="w-full md:max-w-md mx-auto vendordetail rounded-xl cursor-pointer px-4 py-6 bg-[#1F1F1F]">
            {/* Phone Section */}
            <div className="w-full flex flex-col items-center justify-center gap-1 mb-4 text-center">
                <p className="text-[#FFFFFFBD] font-poppins text-sm">Phone</p>
                <h3 className="text-white font-poppins font-medium text-base sm:text-lg">{vendordetail?.mobile || "N/A"}</h3>
            </div>

            {/* Divider */}
            <div className="h-px w-4/5 mx-auto bg-white opacity-30 mb-4" />

            {/* Email Section */}
            <div className="w-full flex flex-col items-center justify-center gap-1 text-center">
                <p className="text-[#FFFFFFBD] font-poppins text-sm">Email</p>
                <h3 className="text-white font-poppins font-medium text-base sm:text-lg break-all">
                    {vendordetail?.email || "N/A"}
                </h3>
            </div>
        </div>
    );
}

export default VenderDetail;
