import { Suspense, lazy } from 'react';
import StoreDescription from './StoreViewDescription';
import VideoSectionDetailScreen from './VideoSectionDetailScreen';

// Lazy load components
const HeaderSectionImage = lazy(() => import('./HeaderSectionImage'));
const StoreNamewithRating = lazy(() => import('./StoreNamewithRating'));
const StoreViewLocation = lazy(() => import('./StoreViewLocation'));
const VenderDetail = lazy(() => import('./VenderDetail'));
const VenderDetailInformation = lazy(() => import('./VenderDetailInformation'));
const EmployyeCount = lazy(() => import('./EmployyeCount'));
const SocilMediicon = lazy(() => import('./SocilMediicon'));
const BusinessHoursDetail = lazy(() => import('./BusinessHoursDetail'));

function StoreOverview() {
  return (
    <div className='w-full p-4 flex gap-5 md:flex-row  flex-col '>
      {/* Left side detail */ }
      <Suspense fallback={<div>Loading  section...</div>}>
        <div className='  w-full  md:w-[70%] flex flex-col gap-5'>
          <HeaderSectionImage />
          <StoreNamewithRating />
          <StoreDescription/>
          <StoreViewLocation />
        </div>
      </Suspense>


      {/* Right side detail */}
      <Suspense fallback={<div>Loading  section...</div>}>
        <div className='  w-full  md:w-[30%] flex flex-col gap-5'>
          <VenderDetail />
          <VenderDetailInformation />
          <EmployyeCount />
          <SocilMediicon />
          <BusinessHoursDetail />
          <VideoSectionDetailScreen/>
        </div>
      </Suspense>

    </div>
  );
}

export default StoreOverview;
