import React from "react";
import { useAppSelector } from "../../../../Hooks/Hooks";
import icon from "../../../../assets/Images/feature.png";
import { MdOutlineStar } from "react-icons/md";
import { IoIosStarHalf } from "react-icons/io";

function StoreNamewithRating() {
    const sernamedetail = useAppSelector((state) => state.adminStore.data?.service)?.stores;


    console.log("sernamedetailsernamedetail" , sernamedetail)


 

    return (
        <div className=" w-full  rounded-lg mt-[1.2rem]  border relative  border-bordercolor  px-3  py-6">
            {Number(sernamedetail?.is_feature) === 1 && (
                <div className="absolute   right-2   h-auto bg-[#FF2929]  top-[-1rem] z-10 w-fit px-2 py-1 rounded-lg flex justify-center items-center">
                    <img src={icon} alt="feature icon" className="object-contain w-4 h-4" />
                    <button className="text-white font-poppins text-sm">Sponsored</button>
                </div>
            )}

            <div className=" w-full flex justify-between   gap-3 items-center">
                <h4 className="font-poppins font-medium   text-textcolor text-xl cursor-pointer line-clamp-1">{sernamedetail?.service_name}</h4>

                <div>
                    <button className=" bg-[#0046AE1A] px-2 py-1  text-[#0046AE]  rounded-lg   w-fit">{sernamedetail?.category}</button>
                </div>
            </div>

            <div className="  w-full flex justify-baseline  items-center  mt-4">
                <div className="w-full flex justify-start items-center gap-4">
                    <div className="flex gap-1 font-poppins">
                        {[...Array(Math.floor(Number(sernamedetail?.totalAvgReview) || 0))].map((_, index) => (
                            <MdOutlineStar key={`full-${index}`} className="text-[#FFA41C]" />
                        ))}
                        {Number(sernamedetail?.totalAvgReview) % 1 !== 0 && Number(sernamedetail?.totalAvgReview) > 0 && <IoIosStarHalf className="text-[#FFA41C]" />}
                        {[...Array(5 - Math.ceil(Number(sernamedetail?.totalAvgReview) || 0))].map((_, index) => (
                            <MdOutlineStar key={`empty-${index}`} className="text-[#D1D1D1]" />
                        ))}
                    </div>
                    <div className="flex justify-start items-center gap-1">
                        <p className={` font-poppins font-normal text-sm cursor-pointer   text-[#5C5C5C]`}>({`${sernamedetail?.totalReviewCount}`} Review)</p>
                    </div>
                </div>

                <p className={` font-poppins text-sm w-full flex justify-end items-end  text-[#636363] `}>{sernamedetail?.total_years_count} Years in Business</p>
            </div>
        </div>
    );
}

export default StoreNamewithRating;
