"use client";
import { useAppSelector } from "../../../../Hooks/Hooks";

function BusinessHoursDetail() {
  const store = useAppSelector((state) => state.adminStore.data?.service?.stores);

  // Fallbacks
  const openDaysStr = store?.open_days || ""; // e.g., "Mon, Tue, Wed, Thu, Sat, Sun"
  const openTime = store?.open_time || "09:00 AM";
  const closeTime = store?.close_time || "06:00 PM";

  // Convert to array of days
  const openDays = openDaysStr.split(",").map((d) => d.trim()); // ['Mon', 'Tue', ...]
  const allDays = ["Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"];
  const closedDays = allDays.filter((day) => !openDays.includes(day)); // any not in openDays

  const daysOfWeek = [
    { day: "Mon", label: "Monday" },
    { day: "Tue", label: "Tuesday" },
    { day: "Wed", label: "Wednesday" },
    { day: "Thu", label: "Thursday" },
    { day: "Fri", label: "Friday" },
    { day: "Sat", label: "Saturday" },
    { day: "Sun", label: "Sunday" },
  ];

  return (
    <div className="p-4 rounded-lg bg-primary border-bordercolor  text-textcolor border">
      {/* Heading */}
      <div className="text-lg font-medium font-poppins mb-4">Business Hours</div>

      {/* Days List */}
      <div className="w-full flex flex-col gap-4">
        {daysOfWeek.map((item) => {
          const isOpen = openDays.includes(item.day);
          const status = isOpen ? `${openTime} - ${closeTime}` : "Closed";

          return (
            <div key={item.day} className="w-full flex justify-between items-center">
              <div className="text-sm font-medium font-poppins  text-textcolor ">
                {item.label}
              </div>
              <div
                className={`text-sm font-medium font-poppins ${
                  isOpen ? "  text-textcolor " : "text-[#FF0000]"
                }`}
              >
                {status}
              </div>
            </div>
          );
        })}
      </div>
    </div>
  );
}

export default BusinessHoursDetail;
