"use client";
import React from "react";
import { useAppSelector } from "../../../../Hooks/Hooks";
import notfound from "../../../../assets/Images/notfound.png";
import WithoutSorttableHeader from "../../../../Componets/TableComponets/WithoutSorttableHeader";
import SimpletextTableBody from "../../../../Componets/TableComponets/SimpletextTableBody";
import TableDateTimeDisplay from "../../../../Componets/TableComponets/TableDateTimeDisplay";
import SimpletextTableBodyReview from "../../../../Componets/TableComponets/SimpletextTableBodyReview";

function SponsorPayment() {
  const spocelist = useAppSelector((state) => state.adminStore.data?.service.GoalData || []);
  console.log("list slice values @@@", spocelist[0]?.status);

  return (
    <div className="p-4">
      <div className="relative border border-bordercolor rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
        <div className="min-w-[1200px]">
          {/* Table Header */}
          <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4 font-medium text-sm text-textcolor">
            <div className="w-[4%]"><WithoutSorttableHeader label="S.L" /></div>
            <div className="w-[10%]"><WithoutSorttableHeader label="CAMPAIGN NAME" /></div>
            <div className="w-[10%]"><WithoutSorttableHeader label="LOCATION" /></div>
            <div className="w-[10%]"><WithoutSorttableHeader label="AREA COVERED" /></div>
            <div className="w-[10%]"><WithoutSorttableHeader label="PRICE" /></div>
            <div className="w-[10%]"><WithoutSorttableHeader label="START DATE" /></div>
            <div className="w-[10%]"><WithoutSorttableHeader label="END DATE" /></div>
            <div className="w-[10%]"><WithoutSorttableHeader label="PAYMENT MODE" /></div>
            <div className="w-[16%]"><WithoutSorttableHeader label="CREATED DATE/TIME" /></div>
            <div className="w-[10%]"><WithoutSorttableHeader label="STATUS" /></div>
          </div>

          {/* Table Body */}
          <div className="relative">
            {spocelist.length > 0 ? (
              spocelist.map((item, index) => (
                <div
                  key={item.id}
                  className={`flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 text-sm font-poppins gap-4 ${index % 2 === 0 ? "bg-white dark:bg-primary" : "bg-[#00162e0a] dark:bg-primary"}`}
                >
                  <div className="w-[4%]">{index + 1}</div>
                  <div className="w-[10%] whitespace-pre-wrap break-words text-textcolor"><SimpletextTableBodyReview title={item.campaign_name} /></div>
                  <div className="w-[10%] whitespace-pre-wrap break-words text-textcolor"><SimpletextTableBodyReview title={item.address} /></div>
                  <div className="w-[10%]"><SimpletextTableBody title={item.area_distance} /></div>
                  <div className="w-[10%]"><SimpletextTableBody title={`${item.price}`} /></div>
                  <div className="w-[10%]"><SimpletextTableBody title={item.start_date} /></div>
                  <div className="w-[10%]"><SimpletextTableBody title={item.end_date} /></div>

                  <div className="w-[10%]">
                    <div
                      className={`w-fit rounded-xl px-3 py-1 font-medium ${{
                          user: "bg-[#D4F1E0] text-[#4CAF50]",
                          vendor: "bg-[#D2DFF5] text-[#0046AE]",
                          stripe: "bg-[#E0F7FA] text-[#00ACC1]",
                          flutterwave: "bg-[#FFF3E0] text-[#FB8C00]",
                          razorpay: "bg-[#F3E5F5] text-[#8E24AA]",
                          googlepay: "bg-[#E0F2F1] text-[#00796B]",
                        }[item.payment_mode] || "bg-gray-200 text-gray-600"
                        }`}
                    >
                      {{
                        user: "Customer",
                        vendor: "Vendor",
                        stripe: "Stripe",
                        flutterwave: "Flutterwave",
                        razorpay: "Razorpay",
                        googlepay: "Google Pay",
                      }[item.payment_mode] || "Unknown"}
                    </div>
                  </div>

                  <div className="w-[16%]"><TableDateTimeDisplay dateString={item.created_at} /></div>

                  <div className="w-[10%]">
                    <div
                      className={`px-3 py-1 w-fit rounded-full text-sm font-medium ${item.status === "1"
                          ? "bg-green-100 text-green-600"
                          : "bg-red-100 text-red-600"
                        }`}
                    >
                      {item.status === "1" ? "Active" : "Inactive"}
                    </div>
                  </div>
                </div>
              ))
            ) : (
              <div className="p-4 h-[38rem] flex justify-center items-center">
                <div className="w-full flex flex-col items-center h-full justify-center">
                  <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                  <h2 className="font-poppins text-lg text-textcolor mt-4">No Data Found</h2>
                </div>
              </div>
            )}
          </div>
        </div>
      </div>
    </div>
  );
}

export default SponsorPayment;
