import { useSelector } from "react-redux";
import SearchBar from "../../Componets/SearchBar/SearchBar";
import { Link, useNavigate } from "react-router-dom";
import WithoutSorttableHeader from "../../Componets/TableComponets/WithoutSorttableHeader";
import Search from "../../assets/Images/search.png";
import Add from "../../assets/Images/add.png";
import { useAppDispatch, useAppSelector } from "../../Hooks/Hooks";
import useApiPost from "../../Hooks/PostData";
import { useEffect, useState } from "react";
import notfound from "../../assets/Images/notfound.png";
import AvatarWithSpinner from "../../Componets/LoadingComponest";
import { IoStar } from "react-icons/io5";
import TableUserInfo from "../../Componets/TableComponets/TableUserInfo";
import { clearAddPostData } from "../../Appstore/Slice/Storevalues/AddStoreSlice";
import { clearVendordetail } from "../../Appstore/Slice/VendorSlice";
import { clearSelectedCategory } from "../../Appstore/Slice/CategorySelectedIDandValues";
import { resetSubCategoryState } from "../../Appstore/Slice/SubCategorySlice";
import { clearall } from "../../Appstore/Slice/Storevalues/StoreaddDescription";
import { resetDays } from "../../Appstore/Slice/Storevalues/OpenDaySlice";
import { clearCoverImageatc } from "../../Appstore/Slice/UploadServiceAttactmentSlice";
import { clearAllCoverImages } from "../../Appstore/Slice/UploadAddserviceImageSlice";
import { clearall12 } from "../../Appstore/Slice/AddSubcriptionDescription";
import SimpletextTableBody from "../../Componets/TableComponets/SimpletextTableBody";
import ReelListPagination from "../../Componets/PaginationComponets/ReelListPagination";
import { setPaginationReelList } from "../../Appstore/Slice/PaginationSlice/ReelListPaginationSlice";
import StoreOverview from "./StoreViewDetai/StoreOverview/StoreOverview";
import SubscriptionPayment from "./StoreViewDetai/SubscriptionPayment/SubscriptionPayment";
import SponsorPayment from "./StoreViewDetai/SponsorPayment/SponsorPayment";
import ServiceListStoreView from "./StoreViewDetai/ServiceListStoreView/ServiceListStoreView";
import Apimethod from "../../Hooks/Apimethod";
import { setAdminStoreData } from "../../Appstore/Slice/AdminStoreSlice";
import StoreReviewDetail from "./StoreViewDetai/StoreReviewDetail/StoreReviewDetail";
import toast from "react-hot-toast";
import { MdArrowBack } from "react-icons/md";

function StoreView() {
    const dispatch = useAppDispatch();
    const navigate = useNavigate();

    const isSidebarOpen = useSelector((state: any) => state.sidebar.isOpen);
    const pagination = useAppSelector((state) => state.ReelListPaginationSlice);
    const { current_page, records_per_page } = pagination;
    const isApiCallTriggered = useAppSelector((state) => state.toggle.value);


    const IS_DEMO = import.meta.env.VITE_IS_DEMO === 'true';


    const [search, setSearch] = useState("");

    const storIDViews = sessionStorage.getItem("storIDViews");

    const { data, postData, loading } = useApiPost();
    const { makeRequest } = Apimethod();

    /**
     * Fetch reel list data based on pagination and search
     */
    useEffect(() => {
        if (!storIDViews) return;

        const params = {
            page: current_page,
            pageSize: records_per_page,
            search: search.trim(),
            service_id: storIDViews,
        };

        postData("/view-service", params);
    }, [current_page, records_per_page, search, storIDViews]);

    /**
     * Update pagination state from API response
     */
    useEffect(() => {
        if (data?.Pagination) {
            dispatch(setPaginationReelList(data.Pagination));
        }
    }, [data?.Pagination, dispatch]);

    /**
     * Trigger API call manually when toggle is set
     */
    useEffect(() => {
        if (isApiCallTriggered) {
            const payload = new FormData();
            if (storIDViews) payload.append("service_id", storIDViews);

            postData("/view-service", payload);
        }
    }, [isApiCallTriggered]);

    /**
     * Fetch specific store data and store in slice
     */
    useEffect(() => {
        if (!storIDViews) return;

        const fetchStoreData = async () => {
            try {
                const formData = new FormData();
                formData.append("service_id", storIDViews);

                const res = await makeRequest(
                    "/view-store",
                    formData,
                    "multipart/form-data",
                    "POST"
                );

                if (res?.service) {
                    dispatch(setAdminStoreData(res));
                }
            } catch (error) {
                console.error("Failed to fetch store view data", error);
            }
        };

        fetchStoreData();
    }, [storIDViews, dispatch]);

    /**
     * Navigation handler to clear store and redirect
     */
    const handleNavigate = () => {


        if (IS_DEMO) {
            toast.error("This action is disabled in the demo version.");
            return;
        }
        navigate(`/add-store`);
        // Clear all related states
        dispatch(clearAddPostData());
        dispatch(clearVendordetail());
        dispatch(clearSelectedCategory());
        dispatch(resetSubCategoryState());
        dispatch(clearall());
        dispatch(resetDays());
        dispatch(clearCoverImageatc());
        dispatch(clearAllCoverImages());
        dispatch(clearall12());
    };
    const [option, setOption] = useState("StoreOverview");

    return (
        <div className={`bg-primary ${isSidebarOpen ? "xl:pl-20" : "xl:pl-72"}`}>
            <SearchBar />
            <div className="px-4 pb-10 xl:px-6">
                <div className="flex justify-between border-t-[#F2F2F2] py-3">
                    <h2 className="text-textcolor font-poppins text-xl font-semibold pt-3">Store View List  </h2>
                    <div className="relative">
                        <div className="absolute left-2 top-1/2 flex transform -translate-y-1/2 items-center p-2">
                            <img src={Search} alt="Search" className="h-4 w-4 md:h-5 md:w-5" />
                        </div>
                        <div className=" w-full">
                            <input
                                type="text"
                                placeholder="Search by name ,email..."
                                className="w-[180px] md:w-[250px] pl-10 py-2 text-sm placeholder:text-placeholdercolor
              border border-bordercolor border-opacity-10 rounded-lg bg-[#00000005] 
              focus:outline-none focus:ring-1 focus:ring-gray-600 
              placeholder:dark:text-tableDarkLarge "
                                onChange={(e) => setSearch(e.target.value)}
                                value={search}
                            />
                        </div>
                    </div>
                </div>

                <div className="flex items-center  flex-col md:flex-row  gap-y-4 justify-between">
                    <div className="flex items-center  gap-2">
                        <Link to="/dashboard">
                            <h3 className="text-[#3A3A3A] font-poppins text-base font-semibold">Dashboard</h3>
                        </Link>
                        <div className="rounded-full w-1 h-1 bg-[#E0E0E0]" />
                        <h3 className="text-[#858585] font-poppins text-base">Store View List</h3>
                    </div>

                    <div className=" flex gap-2">
                        <button className="flex gap-1.5 mr-1 py-2 cursor-pointer place-items-center px-4 font-poppins font-medium text-white rounded-md bggradient" onClick={handleNavigate}>
                            <img src={Add} className="w-4 h-4" />
                            <p className="md:text-sm text-xs">Add Store</p>
                        </button>

                        <button
                            onClick={() => navigate(-1)} // go back
                            className="flex items-center gap-2 px-4 py-[6px] text-white cursor-pointer bggradient font-poppins rounded-md"
                        >
                            <MdArrowBack size={20} />
                            Back
                        </button>
                    </div>
                </div>

                {/*  vendor store detail => service */}
                <div className="relative border border-bordercolor  hidden rounded-lg mt-8 mx-4 sm:mx-0 overflow-x-auto w-full">
                    <div className="min-w-[1200px]">
                        {/* Table Header */}
                        <div className="flex items-center px-4 py-4 text-left border-b bg-headercolortable border-b-bordercolor sm:pl-8 gap-4">
                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="S.L" />
                            </div>
                            <div className="w-[40%]">
                                <WithoutSorttableHeader label="SERVICE" />
                            </div>
                            <div className="w-[40%]">
                                <WithoutSorttableHeader label="VENDOR" />
                            </div>

                            <div className="w-[10%]">
                                <WithoutSorttableHeader label="PRICE" />
                            </div>
                        </div>
                        <div className="relative">
                            {loading ? (
                                <div className="h-[400px] flex items-center justify-center">
                                    <AvatarWithSpinner />
                                </div>
                            ) : data?.service ? (
                                <div className={`flex items-center px-4 py-3 border-b border-bordercolor sm:pl-8 bg-white dark:bg-primary`}>
                                    {/* S.L */}
                                    <div className="w-[10%] text-sm text-textcolor font-poppins">1</div>

                                    {/* Store */}
                                    <div className="w-[40%] flex gap-3 items-center">
                                        <div className="w-10 h-10 rounded-full overflow-hidden">
                                            <img src={data.service.stores?.[0]?.store_images?.[0]?.url} alt="Service" className="w-full h-full object-cover" />
                                        </div>
                                        <div className="flex flex-col">
                                            <div className="flex items-center gap-2">
                                                <h4 className="text-[#0046AE] text-sm font-poppins">{data.service.service_name}</h4>
                                                <div className="flex items-center gap-1">
                                                    <IoStar className="text-yellow-400" />
                                                    <p className="text-gray-400 text-sm font-poppins">{data.service.avg_review || "N/A"}</p>
                                                </div>
                                            </div>
                                            <p className="text-[#a4a9b4] font-poppins">Price: {data.service.price_range || data.service.stores?.[0]?.price || "N/A"}</p>
                                        </div>
                                    </div>

                                    {/* Vendor */}
                                    <div className="w-[40%]">
                                        <TableUserInfo
                                            profilePic={data.service.vendor?.image}
                                            username={`${data.service.vendor?.first_name || ""} ${data.service.vendor?.last_name || ""}`}
                                            email={data.service.vendor?.email || "N/A"}
                                            mobile="N/A"
                                            onClick={() => { }}
                                        />
                                    </div>

                                    {/* Price Column */}
                                    <div className="w-[10%]">
                                        <SimpletextTableBody title={data.service.stores?.[0]?.price || "N/A"} />
                                    </div>
                                </div>
                            ) : (
                                <div className="p-4 h-[38rem] flex justify-center items-center">
                                    <div className="w-full flex flex-col items-center h-full justify-center">
                                        <img src={notfound} alt="Not Found" className="w-1/2 max-h-[40vh] object-contain" />
                                        <h2 className="font-poppins text-lg text-textcolor mt-4">No Data Found</h2>
                                    </div>
                                </div>
                            )}
                        </div>
                    </div>
                    <ReelListPagination />
                </div>

                <div className="mt-5 border rounded-lg border-bordercolor ">
                    <div className="grid  md:grid-cols-2   xl:grid-cols-5">
                        <button
                            className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "StoreOverview" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                            onClick={() => setOption("StoreOverview")}
                        >
                            Store Overview
                        </button>

                        <button
                            className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "SubscriptionPayment" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                            onClick={() => setOption("SubscriptionPayment")}
                        >
                            Subscription Payment
                        </button>
                        <button
                            className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "SponsorPayment" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                            onClick={() => setOption("SponsorPayment")}
                        >
                            Sponsor Payment
                        </button>
                        <button
                            className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "ServiceListStoreView" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                            onClick={() => setOption("ServiceListStoreView")}
                        >
                            Service List
                        </button>

                        <button
                            className={`font-poppins font-semibold w-full py-3 border-b  cursor-pointer border-bordercolor rounded-tl-lg text-sm ${option === "StoreReviewDetail" ? "text-[#FFFFFF]  bggradient" : " text-[#5B5B5B]"}`}
                            onClick={() => setOption("StoreReviewDetail")}
                        >
                            Review List
                        </button>
                    </div>

                    {/* Twilio */}
                    {option === "StoreOverview" && <StoreOverview />}

                    {option === "SubscriptionPayment" && <SubscriptionPayment />}

                    {option === "SponsorPayment" && <SponsorPayment />}

                    {option === "ServiceListStoreView" && <ServiceListStoreView />}
                    {option === "StoreReviewDetail" && <StoreReviewDetail />}
                </div>
            </div>
        </div>
    );
}
export default StoreView;
